/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;
import org.eclipse.osee.orcs.db.internal.search.util.TokenOrderProcessor;

public class AnyTokenOrderProcessor
implements TokenOrderProcessor {
    private final TrackingMap trackingSet;
    private final List<MatchLocation> locations = new LinkedList<MatchLocation>();
    private int numTokensToMatch = 0;

    public AnyTokenOrderProcessor() {
        this.trackingSet = new TrackingMap();
    }

    @Override
    public int getTotalTokensToMatch() {
        return this.numTokensToMatch;
    }

    @Override
    public void acceptTokenToMatch(String token) {
        this.trackingSet.add(token);
        ++this.numTokensToMatch;
    }

    @Override
    public boolean processToken(String token, MatchLocation match) {
        if (this.trackingSet.found(token)) {
            this.locations.add(this.createMatchLocation(match.getStartPosition(), match.getEndPosition()));
        }
        return this.trackingSet.areAllFound();
    }

    @Override
    public List<MatchLocation> getLocations() {
        return this.locations;
    }

    @Override
    public void clearAllLocations() {
        this.locations.clear();
    }

    private MatchLocation createMatchLocation(int start, int end) {
        return new MatchLocation(start + 1, end);
    }

    private static final class TrackingMap {
        private final Map<String, MutableInteger> map = new LinkedHashMap<String, MutableInteger>();
        private int total = 0;

        private TrackingMap() {
        }

        public void add(String value) {
            MutableInteger stored = this.map.get(value);
            if (stored == null) {
                this.map.put(value, new MutableInteger(1));
            } else {
                stored.getValueAndInc();
            }
            ++this.total;
        }

        public boolean found(String value) {
            MutableInteger stored = this.map.get(value);
            if (stored != null) {
                stored.getValueAndInc(-1);
                if (stored.getValue() > -1) {
                    --this.total;
                }
                return true;
            }
            return false;
        }

        public boolean areAllFound() {
            return this.total == 0;
        }
    }
}

