/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.enums.ObjectType;
import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;

public class RelationTypeExistsSqlHandler
extends AbstractRelationSqlHandler<CriteriaRelationTypeExists> {
    private String relAlias;
    private String txsAlias;

    @Override
    public void addTables(AbstractSqlWriter writer) {
        super.addTables(writer);
        this.relAlias = writer.addTable(TableEnum.RELATION_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.RELATION);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        super.addPredicates(writer);
        writer.write(this.relAlias);
        writer.write(".rel_link_type_id = ?");
        writer.addParameter(((CriteriaRelationTypeExists)this.criteria).getType());
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        if (!aliases.isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write("(");
                writer.write(this.relAlias);
                writer.write(".a_art_id = ");
                writer.write(artAlias);
                writer.write(".art_id");
                writer.write(" OR ");
                writer.write(this.relAlias);
                writer.write(".b_art_id = ");
                writer.write(artAlias);
                writer.write(".art_id)");
                if (index + 1 < aSize) {
                    writer.writeAndLn();
                }
                ++index;
            }
        }
        writer.writeAndLn();
        writer.write(this.relAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id");
        writer.writeAndLn();
        writer.writeTxBranchFilter(this.txsAlias);
    }
}

