/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaMergeBranchFor;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class MergeBranchForSqlHandler
extends SqlHandler<CriteriaMergeBranchFor> {
    private CriteriaMergeBranchFor criteria;
    private String brAlias;
    private String mergeAlias;

    @Override
    public void setData(CriteriaMergeBranchFor criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.mergeAlias = writer.addTable(TableEnum.MERGE_TABLE);
        this.brAlias = writer.getMainTableAlias(TableEnum.BRANCH_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEqualsParameterAnd(this.mergeAlias, "source_branch_id", this.criteria.getSource());
        writer.writeEqualsParameterAnd(this.mergeAlias, "dest_branch_id", this.criteria.getDestination());
        writer.writeEquals(this.mergeAlias, "merge_branch_id", this.brAlias, "branch_id");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.MERGE_BRANCH_FOR.ordinal();
    }
}

