/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.OrcsTypesData;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.StandardOptions;
import org.eclipse.osee.jdbc.JdbcClient;

public class OrcsTypeLoader {
    private final IResourceManager resourceManager;
    private final JdbcClient jdbcClient;

    public OrcsTypeLoader(JdbcClient jdbcClient, IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.jdbcClient = jdbcClient;
    }

    public IResource load() {
        try {
            LinkedHashSet<String> uriPaths = new LinkedHashSet<String>();
            URI uri = this.getUriPaths(uriPaths);
            Conditions.checkExpressionFailOnTrue((boolean)uriPaths.isEmpty(), (String)"No orcs types found", (Object[])new Object[0]);
            return new OrcsTypesResource(uri, uriPaths);
        }
        catch (URISyntaxException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public boolean isTypesResourcesValid() {
        LinkedHashSet<String> uriPaths;
        boolean valid;
        block4: {
            valid = true;
            uriPaths = new LinkedHashSet<String>();
            this.getUriPaths(uriPaths);
            if (!uriPaths.isEmpty()) break block4;
            return false;
        }
        try {
            for (String path : uriPaths) {
                PropertyStore options = new PropertyStore();
                IResourceLocator locator = this.resourceManager.getResourceLocator(path);
                IResource resource = this.resourceManager.acquire(locator, options);
                if (resource != null) continue;
                valid = false;
                break;
            }
        }
        catch (URISyntaxException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return valid;
    }

    private URI getUriPaths(Collection<String> uriPaths) throws URISyntaxException {
        String resourceUri = String.format("osee:/datastore.orcs.types_%s.osee", Lib.getDateTimeString());
        URI uri = new URI(resourceUri);
        this.jdbcClient.runQuery(stmt -> {
            boolean bl = uriPaths.add(stmt.getString("uri"));
        }, "select uri, attr.attr_id from osee_tuple2 t2, osee_txs txs1, osee_attribute attr, osee_txs txs2 where tuple_type = ? and t2.gamma_id = txs1.gamma_id and txs1.branch_id = ? and txs1.tx_current = ? and e1 = ? and e2 = attr.attr_id and attr.gamma_id = txs2.gamma_id and txs2.branch_id = txs1.branch_id and txs2.tx_current = ?", new Object[]{CoreTupleTypes.OseeTypeDef, CoreBranches.COMMON, TxCurrent.CURRENT, OrcsTypesData.OSEE_TYPE_VERSION, TxCurrent.CURRENT});
        return uri;
    }

    private final class OrcsTypesResource
    implements IResource {
        private final URI uri;
        private final Collection<String> resources;

        public OrcsTypesResource(URI uri, Collection<String> resources) {
            this.uri = uri;
            this.resources = resources;
        }

        public InputStream getContent() {
            return this.asInputStream(this.resources);
        }

        public URI getLocation() {
            return this.uri;
        }

        public String getName() {
            String value = this.uri.toASCIIString();
            return value.substring(value.lastIndexOf("/") + 1, value.length());
        }

        public boolean isCompressed() {
            return false;
        }

        private InputStream asInputStream(Collection<String> resources) {
            PropertyStore options = new PropertyStore();
            options.put(StandardOptions.DecompressOnAquire.name(), "true");
            StringBuilder builder = new StringBuilder();
            for (String path : resources) {
                IResourceLocator locator = OrcsTypeLoader.this.resourceManager.getResourceLocator(path);
                IResource resource = OrcsTypeLoader.this.resourceManager.acquire(locator, options);
                if (resource == null) {
                    throw new OseeStateException("Types resource can not be null for %s", new Object[]{path});
                }
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = resource.getContent();
                        String oseeTypeFragment = Lib.inputStreamToString((InputStream)inputStream);
                        oseeTypeFragment = oseeTypeFragment.replaceAll("import\\s+\"", "// import \"");
                        builder.append("\n//////////////     ");
                        builder.append(resource.getName());
                        builder.append("\n\n");
                        builder.append(oseeTypeFragment);
                    }
                    catch (IOException ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                        Lib.close((AutoCloseable)inputStream);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close((AutoCloseable)inputStream);
                    throw throwable;
                }
                Lib.close((AutoCloseable)inputStream);
            }
            InputStream toReturn = null;
            try {
                toReturn = Lib.stringToInputStream((String)builder.toString());
            }
            catch (UnsupportedEncodingException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            return toReturn;
        }
    }
}

