/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.util.Address;

public class InvalidTxCurrentsAndModTypesCallable
extends AbstractDatastoreTxCallable<Void> {
    private static final String SELECT_ADDRESSES = "select %s, txs.branch_id, txs.transaction_id, txs.gamma_id, txs.mod_type, txs.app_id, txs.tx_current, txd.tx_type from %s t1, osee_txs%s txs, osee_tx_details txd where t1.gamma_id = txs.gamma_id and txd.transaction_id = txs.transaction_id and txs.branch_id = txd.branch_id order by txs.branch_id, %s, txs.transaction_id desc, txs.gamma_id desc";
    private static final String DELETE_ADDRESS = "delete from osee_txs%s where transaction_id = ? and gamma_id = ? and branch_id = ?";
    private static final String UPDATE_ADDRESS = "update osee_txs%s set tx_current = ? where transaction_id = ? and gamma_id = ? and branch_id = ?";
    private final List<Address> addresses = new ArrayList<Address>();
    private final List<Object[]> purgeData = new ArrayList<Object[]>();
    private final List<Object[]> currentData = new ArrayList<Object[]>();
    private final String tableName;
    private final String columnName;
    private final boolean isFixOperationEnabled;
    private final String txsTableName;

    public InvalidTxCurrentsAndModTypesCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, String operationName, String tableName, String columnName, boolean isFixOperationEnabled, boolean archived) {
        super(logger, session, jdbcClient);
        this.tableName = tableName;
        this.columnName = columnName;
        this.isFixOperationEnabled = isFixOperationEnabled;
        this.txsTableName = archived ? "_archived" : "";
    }

    private void fixIssues() {
        if (this.isFixOperationEnabled) {
            this.checkForCancelled();
            this.getJdbcClient().runBatchUpdate(String.format(DELETE_ADDRESS, this.txsTableName), this.purgeData);
            this.getJdbcClient().runBatchUpdate(String.format(UPDATE_ADDRESS, this.txsTableName), this.currentData);
        }
    }

    private void consolidateAddressing() {
        this.checkForMultipleVersionsInOneTransaction();
        this.checkForIdenticalAddressingInDifferentTransactions();
        this.checkForMultipleCurrents();
        this.checkForInvalidMergedModType();
        if (this.issueDetected()) {
            for (Address address : this.addresses) {
                if (address.isPurge()) {
                    this.logIssue("purged", address);
                    this.purgeData.add(new Object[]{address.getTransactionId(), address.getGammaId(), address.getBranch()});
                    continue;
                }
                if (address.getCorrectedTxCurrent() != null) {
                    this.logIssue("corrected txCurrent: " + address.getCorrectedTxCurrent(), address);
                    this.currentData.add(new Object[]{address.getCorrectedTxCurrent(), address.getTransactionId(), address.getGammaId(), address.getBranch()});
                    continue;
                }
                this.logIssue("would have fixed merge here");
            }
        }
    }

    private void checkForInvalidMergedModType() {
        int index = this.addresses.size() - 1;
        Address lastAddress = this.addresses.get(index);
        if (!lastAddress.isBaselineTx()) {
            while (index > -1) {
                if (!this.addresses.get(index).isPurge()) {
                    this.addresses.get(index).getModType();
                    return;
                }
                --index;
            }
        }
    }

    private void checkForIdenticalAddressingInDifferentTransactions() {
        Address previousAddress = null;
        for (Address address : this.addresses) {
            if (previousAddress != null && address.hasSameGamma(previousAddress) && address.hasSameModType(previousAddress) && address.hasSameApplicability(previousAddress)) {
                previousAddress.setPurge(true);
            }
            previousAddress = address;
        }
    }

    private boolean issueDetected() {
        for (Address address : this.addresses) {
            if (!address.hasIssue()) continue;
            return true;
        }
        return false;
    }

    private void checkForMultipleVersionsInOneTransaction() {
        Address previousAddress = null;
        for (Address address : this.addresses) {
            if (address.isSameTransaction(previousAddress) && previousAddress != null) {
                if (address.hasSameModType(previousAddress) || !address.getModType().isDeleted() && previousAddress.getModType().isEdited()) {
                    address.setPurge(true);
                } else {
                    this.logIssue("multiple versions in one transaction - unknown case", address);
                }
            }
            previousAddress = address;
        }
    }

    private void checkForMultipleCurrents() {
        boolean mostRecentTx = true;
        for (Address address : this.addresses) {
            if (address.isPurge()) continue;
            if (mostRecentTx) {
                address.ensureCorrectCurrent();
                mostRecentTx = false;
                continue;
            }
            address.ensureNotCurrent();
        }
    }

    @Override
    protected Void handleTxWork(JdbcConnection connection) {
        this.checkForCancelled();
        String sql = String.format(SELECT_ADDRESSES, this.columnName, this.tableName, this.txsTableName, this.columnName);
        Address[] previousAddress = new Address[1];
        Consumer<JdbcStatement> consumer = stmt -> {
            this.checkForCancelled();
            ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
            TxCurrent txCurrent = TxCurrent.valueOf((int)stmt.getInt("tx_current"));
            TransactionDetailsType type = TransactionDetailsType.valueOf((int)stmt.getInt("tx_type"));
            ApplicabilityId appId = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
            Address address = new Address(type.isBaseline(), stmt.getLong("branch_id"), stmt.getInt(this.columnName), stmt.getLong("transaction_id"), GammaId.valueOf((Long)stmt.getLong("gamma_id")), modType, appId, txCurrent);
            if (!address.isSimilar(previousAddress[0])) {
                if (!this.addresses.isEmpty()) {
                    this.consolidateAddressing();
                }
                this.addresses.clear();
            }
            this.addresses.add(address);
            addressArray[0] = address;
        };
        this.getJdbcClient().runQuery(consumer, 10000, sql, new Object[0]);
        this.fixIssues();
        return null;
    }

    private void logIssue(String message, Address address) {
        this.getLogger().info("msg[%s] - branchId[%s] itemId[%s] txId[%s] gammaId[%s] modType[%s] txCurrent[%s]", new Object[]{message, address.getBranch(), address.getItemId(), address.getTransactionId(), address.getGammaId(), address.getModType(), address.getTxCurrent()});
    }

    private void logIssue(String message) {
        this.getLogger().info(message, new Object[0]);
    }
}

