/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.define.rest.internal.SafetyReportGenerator;
import org.eclipse.osee.define.rest.internal.ValidatingSafetyReportGenerator;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.OrcsApi;

public final class SafetyStreamingOutput
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final BranchId branchId;
    private final String codeRoot;
    private final ActivityLog activityLog;
    private final boolean validate;

    public SafetyStreamingOutput(ActivityLog activityLog, OrcsApi orcsApi, BranchId branchId, String codeRoot, String isOn) {
        this.activityLog = activityLog;
        this.orcsApi = orcsApi;
        this.branchId = branchId;
        this.codeRoot = codeRoot;
        this.validate = isOn != null && isOn.equals("on");
    }

    public void write(OutputStream output) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(output);
            if (this.validate) {
                ValidatingSafetyReportGenerator teamSafetyReport = new ValidatingSafetyReportGenerator(this.activityLog);
                teamSafetyReport.runOperation(this.orcsApi, this.branchId, this.codeRoot, writer);
            } else {
                SafetyReportGenerator safetyReport = new SafetyReportGenerator(this.activityLog);
                safetyReport.runOperation(this.orcsApi, this.branchId, this.codeRoot, writer);
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }
}

