/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelColumn;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public final class PublishPidsVerificationReport
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final ActivityLog activityLog;
    private final ArtifactId root;
    private ExcelXmlWriter writer;

    public PublishPidsVerificationReport(ActivityLog activityLog, OrcsApi orcsApi, BranchId branch, ArtifactId root) {
        this.activityLog = activityLog;
        this.branch = branch;
        this.orcsApi = orcsApi;
        this.root = root;
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writePidsVerificationSheet();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writePidsVerificationSheet() throws IOException {
        this.writer.startSheet("PIDS Traceability to Results", new ExcelColumn[]{ExcelColumn.newCol(null, (double)320.0), ExcelColumn.newCol(null, (double)200.0), ExcelColumn.newCol(null, (double)320.0), ExcelColumn.newCol(null, (double)320.0)});
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.SubsystemRequirementMsWord});
        Object[] row = new String[]{"Subsystem Requirement", "Subsystem", "Verification Trace", "Results Trace"};
        this.writer.writeRow(row);
        for (ArtifactReadable req : query.getResults()) {
            String sub = req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, "Not Set");
            this.getVerificationsForRequirement(sub, req);
        }
        this.writer.endSheet();
    }

    private void getVerificationsForRequirement(String sub, ArtifactReadable req) throws IOException {
        boolean noVerifications = true;
        for (ArtifactReadable ver : req.getRelated(CoreRelationTypes.Verification__Verifier).getList()) {
            noVerifications = false;
            this.getResultsForVerifications(sub, req, ver);
        }
        if (noVerifications) {
            Object[] row = new String[]{req.getName(), sub, "NO VERIFICATION TRACE", "NO RESULTS TRACE"};
            this.writer.writeRow(row);
        }
    }

    private void getResultsForVerifications(String sub, ArtifactReadable req, ArtifactReadable ver) throws IOException {
        boolean noResults = true;
        for (ArtifactReadable res : ver.getRelated(CoreRelationTypes.Test_Unit_Result__Test_Result).getList()) {
            noResults = false;
            Object[] row = new String[]{req.getName(), sub, ver.getName(), res.getName()};
            this.writer.writeRow(row);
        }
        if (noResults) {
            Object[] row = new String[]{req.getName(), sub, ver.getName(), "NO RESULTS"};
            this.writer.writeRow(row);
        }
    }
}

