/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.services.ImplicitGrantService;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.ClientLogoUriResolver;

public class ImplicitGrantEndpoint
extends ImplicitGrantService {
    private final ClientLogoUriResolver clientLogoUriResolver;
    private boolean useRegisteredRedirectUriIfPossible = true;

    public ImplicitGrantEndpoint(ClientLogoUriResolver clientLogoUriResolver) {
        this.clientLogoUriResolver = clientLogoUriResolver;
    }

    protected Response createGrant(MultivaluedMap<String, String> params, Client client, String redirectUri, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        Response response = super.createGrant(params, client, redirectUri, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        String forwardedServer = OAuthUtil.getForwarderServer();
        if (Strings.isValid((String)forwardedServer)) {
            URI location = response.getLocation();
            String scheme = location.getScheme();
            URI finalUri = UriBuilder.fromPath((String)forwardedServer).scheme(scheme).path(location.getRawPath()).replaceQuery(location.getRawQuery()).fragment(location.getRawFragment()).buildFromEncoded(new Object[0]);
            response = Response.seeOther((URI)finalUri).build();
        }
        return response;
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String redirectUri, String error) {
        Response response = super.createErrorResponse(params, redirectUri, error);
        String forwardedServer = OAuthUtil.getForwarderServer();
        if (Strings.isValid((String)forwardedServer)) {
            URI location = response.getLocation();
            String scheme = location.getScheme();
            URI finalUri = UriBuilder.fromPath((String)forwardedServer).scheme(scheme).path(location.getRawPath()).replaceQuery(location.getRawQuery()).fragment(location.getRawFragment()).buildFromEncoded(new Object[0]);
            response = Response.seeOther((URI)finalUri).build();
        }
        return response;
    }

    public void setUseRegisteredRedirectUriIfPossible(boolean value) {
        this.useRegisteredRedirectUriIfPossible = value;
        super.setUseRegisteredRedirectUriIfPossible(value);
    }

    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, UserSubject subject, String redirectUri, List<OAuthPermission> perms) {
        OAuthAuthorizationData secData = super.createAuthorizationData(client, params, subject, redirectUri, perms);
        String oldReplyTo = secData.getReplyTo();
        URI replyToUri = UriBuilder.fromPath((String)oldReplyTo).buildFromEncoded(new Object[0]);
        String forwardedServer = OAuthUtil.getForwarderServer();
        if (Strings.isValid((String)forwardedServer)) {
            String scheme = replyToUri.getScheme();
            URI newReplyTo = UriBuilder.fromPath((String)forwardedServer).scheme(scheme).path(replyToUri.getRawPath()).replaceQuery(replyToUri.getRawQuery()).fragment(replyToUri.getRawFragment()).buildFromEncoded(new Object[0]);
            secData.setReplyTo(newReplyTo.toString());
        }
        secData.setApplicationName(client.getApplicationName());
        secData.setApplicationCertificates(client.getApplicationCertificates());
        UriInfo uriInfo = this.getMessageContext().getUriInfo();
        URI clientLogoUri = this.clientLogoUriResolver.getClientLogoUri(uriInfo, client);
        if (Strings.isValid((String)forwardedServer)) {
            String scheme = clientLogoUri.getScheme();
            URI newClientLogoUri = UriBuilder.fromPath((String)forwardedServer).scheme(scheme).path(clientLogoUri.getRawPath()).replaceQuery(clientLogoUri.getRawQuery()).fragment(clientLogoUri.getRawFragment()).buildFromEncoded(new Object[0]);
            secData.setApplicationLogoUri(newClientLogoUri.toString());
        } else {
            secData.setApplicationLogoUri(clientLogoUri.toString());
        }
        return secData;
    }

    protected String validateRedirectUri(Client client, String redirectUri) {
        List uris = client.getRedirectUris();
        if (redirectUri != null) {
            boolean foundMatch = false;
            for (String uriRegex : uris) {
                if (!redirectUri.matches(uriRegex)) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                redirectUri = null;
            }
        } else if (uris.size() == 1 && this.useRegisteredRedirectUriIfPossible) {
            redirectUri = (String)uris.get(0);
        }
        if (redirectUri == null && uris.size() == 0 && !this.canRedirectUriBeEmpty(client)) {
            this.reportInvalidRequestError("Client Redirect Uri is invalid");
        }
        return redirectUri;
    }
}

