/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.SubjectProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.OAuthEncryption;
import org.eclipse.osee.jaxrs.server.internal.security.util.OseePrincipalImpl;
import org.eclipse.osee.jaxrs.server.security.JaxRsAuthenticator;
import org.eclipse.osee.jaxrs.server.security.JaxRsSessionProvider;
import org.eclipse.osee.jaxrs.server.session.SessionData;
import org.eclipse.osee.logger.Log;

public class SubjectProviderImpl
implements SubjectProvider {
    private static final String SESSION_SECURITY_CONTEXT = "jaxrs.server.session.authentication.object";
    private final Log logger;
    private final JaxRsAuthenticator authenticator;
    private final JaxRsSessionProvider sessionDelegate;
    private final OAuthEncryption serializer;
    private volatile SecretKey secretKey;
    private String secretKeyEncoded;
    private String secretKeyAlgorithm;
    private long sessionTokenExpiration;

    public SubjectProviderImpl(Log logger, JaxRsSessionProvider sessionDelegate, JaxRsAuthenticator authenticator, OAuthEncryption serializer) {
        this.logger = logger;
        this.sessionDelegate = sessionDelegate;
        this.authenticator = authenticator;
        this.serializer = serializer;
    }

    @Override
    public void setSessionTokenExpiration(long sessionTokenExpiration) {
        this.sessionTokenExpiration = sessionTokenExpiration;
    }

    @Override
    public void setSecretKeyEncoded(String secretKeyEncoded) {
        this.secretKeyEncoded = secretKeyEncoded;
    }

    @Override
    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public long getSessionTokenExpiration() {
        return this.sessionTokenExpiration;
    }

    @Override
    public long getSubjectId(UserSubject subject) {
        return OAuthUtil.getUserSubjectUuid(subject);
    }

    public String getName(UserSubject subject) {
        return OAuthUtil.getDisplayName(subject);
    }

    private SecretKey getSecretKey() {
        if (this.secretKey == null) {
            this.secretKey = this.serializer.decodeSecretKey(this.secretKeyEncoded, this.secretKeyAlgorithm);
        }
        return this.secretKey;
    }

    public String createSessionToken(MessageContext mc, MultivaluedMap<String, String> params, UserSubject subject) {
        this.logger.debug("Create Session Token - subject[%s]", new Object[]{subject});
        String sessionAuthenticityToken = null;
        if (this.sessionDelegate != null) {
            Long subjectId = OAuthUtil.getUserSubjectUuid(subject);
            sessionAuthenticityToken = this.sessionDelegate.createAuthenticitySessionToken(subjectId);
        } else {
            HttpSession session = mc.getHttpServletRequest().getSession();
            sessionAuthenticityToken = (String)session.getAttribute("session_authenticity_token");
            if (!Strings.isValid((String)sessionAuthenticityToken)) {
                sessionAuthenticityToken = UUID.randomUUID().toString();
                session.setAttribute("session_authenticity_token", (Object)sessionAuthenticityToken);
            }
        }
        return sessionAuthenticityToken;
    }

    public String getSessionToken(MessageContext mc, MultivaluedMap<String, String> params, UserSubject subject) {
        this.logger.debug("Get Session Token - subject[%s]", new Object[]{subject});
        String sessionAuthenticityToken = null;
        if (this.sessionDelegate != null) {
            Long subjectId = OAuthUtil.getUserSubjectUuid(subject);
            sessionAuthenticityToken = this.sessionDelegate.getSessionAuthenticityToken(subjectId);
        } else {
            HttpSession session = mc.getHttpServletRequest().getSession();
            sessionAuthenticityToken = (String)session.getAttribute("session_authenticity_token");
        }
        return sessionAuthenticityToken;
    }

    public String removeSessionToken(MessageContext mc, MultivaluedMap<String, String> params, UserSubject subject) {
        this.logger.debug("Remove Session Token - subject[%s]", new Object[]{subject});
        String sessionAuthenticityToken = null;
        if (this.sessionDelegate != null) {
            Long subjectId = OAuthUtil.getUserSubjectUuid(subject);
            sessionAuthenticityToken = this.sessionDelegate.removeSessionAuthenticityToken(subjectId);
        } else {
            HttpSession session = mc.getHttpServletRequest().getSession();
            sessionAuthenticityToken = (String)session.getAttribute("session_authenticity_token");
            if (sessionAuthenticityToken != null) {
                session.removeAttribute("session_authenticity_token");
            }
        }
        return sessionAuthenticityToken;
    }

    public UserSubject createUserSubject(MessageContext mc) throws OAuthServiceException {
        UserSubject subject = (UserSubject)mc.getContent(UserSubject.class);
        if (subject == null) {
            SecurityContext securityContext = this.getSecurityContext(mc);
            subject = OAuthUtil.newSubject(securityContext);
        }
        return subject;
    }

    @Override
    public SecurityContext getSecurityContextFromSession(MessageContext mc) {
        SecurityContext securityContext = null;
        if (this.sessionDelegate != null) {
            Map cookies = mc.getHttpHeaders().getCookies();
            for (String cookieName : cookies.keySet()) {
                Cookie cookie = (Cookie)cookies.get(cookieName);
                if (!cookie.getName().equalsIgnoreCase("JSESSIONID")) continue;
                SessionData session = this.sessionDelegate.getSession(cookie.getValue());
                if (session != null) {
                    boolean isExpired = OAuthUtils.isExpired((Long)session.getIssuedAt(), (Long)session.getExpiresIn());
                    if (isExpired) {
                        this.sessionDelegate.removeSession((String)session.getGuid());
                    } else {
                        securityContext = this.recreateSecurityContext(session);
                    }
                }
                break;
            }
        } else {
            HttpSession session = mc.getHttpServletRequest().getSession(false);
            if (session != null) {
                securityContext = (SecurityContext)session.getAttribute(SESSION_SECURITY_CONTEXT);
            }
        }
        OAuthUtil.saveSecurityContext(mc, securityContext);
        return securityContext;
    }

    private SecurityContext recreateSecurityContext(SessionData sessionData) {
        SessionData decryptSessionToken = this.serializer.decryptSessionToken(sessionData.getSubjectToken(), this.getSecretKey());
        UserSubject subject = decryptSessionToken.getSubject();
        HashSet<String> roles = new HashSet<String>();
        roles.addAll(subject.getRoles());
        OseePrincipalImpl principal = new OseePrincipalImpl(decryptSessionToken.getAccountId(), decryptSessionToken.getAccountDisplayName(), decryptSessionToken.getAccountEmail(), subject.getLogin(), sessionData.getAccountName(), decryptSessionToken.getAccountUsername(), decryptSessionToken.getAccountActive(), true, roles, subject.getProperties());
        return OAuthUtil.newSecurityContext(principal);
    }

    @Override
    public void authenticate(MessageContext mc, String scheme, String username, String password) {
        OseePrincipal principal = this.authenticate(scheme, username, password);
        SecurityContext securityContext = OAuthUtil.newSecurityContext(principal);
        if (this.sessionDelegate != null) {
            HttpSession session = mc.getHttpServletRequest().getSession(true);
            SessionData sessionData = this.httpSessionToSessionData(session, securityContext);
            this.sessionDelegate.storeSession(sessionData);
            session.setAttribute(SESSION_SECURITY_CONTEXT, (Object)securityContext);
        } else {
            HttpSession session = mc.getHttpServletRequest().getSession(true);
            session.setAttribute(SESSION_SECURITY_CONTEXT, (Object)securityContext);
        }
        OAuthUtil.saveSecurityContext(mc, securityContext);
    }

    private SessionData httpSessionToSessionData(HttpSession session, SecurityContext securitContext) {
        OseePrincipal principal = (OseePrincipal)securitContext.getUserPrincipal();
        SessionData toReturn = new SessionData(session.getId());
        UserSubject subject = new UserSubject();
        subject.setLogin(principal.getLogin());
        subject.setProperties(principal.getProperties());
        ArrayList roles = new ArrayList();
        roles.addAll(principal.getRoles());
        subject.setRoles(roles);
        toReturn.setSubject(subject);
        toReturn.setAccountActive(principal.isActive());
        toReturn.setAccountDisplayName(principal.getDisplayName());
        toReturn.setAccountEmail(principal.getEmailAddress());
        toReturn.setAccountId((Long)principal.getGuid());
        toReturn.setAccountName(principal.getName());
        toReturn.setAccountUsername(principal.getUserName());
        toReturn.setIssuedAt(OAuthUtils.getIssuedAt());
        toReturn.setExpiresIn(this.getSessionTokenExpiration());
        String token = this.serializer.encryptSessionToken(toReturn, this.getSecretKey());
        toReturn.setSubjectToken(token);
        return toReturn;
    }

    public UserSubject createSubject(String username, String password) {
        OseePrincipal principal = this.authenticate("Basic", username, password);
        return OAuthUtil.newUserSubject(principal);
    }

    private OseePrincipal authenticate(String scheme, String username, String password) {
        this.logger.debug("Authenticate  - scheme[%s] username[%s]", new Object[]{scheme, username});
        return this.authenticator.authenticate(scheme, username, password);
    }

    private SecurityContext getSecurityContext(MessageContext mc) {
        SecurityContext securityContext = (SecurityContext)mc.get(SecurityContext.class);
        if (securityContext == null) {
            securityContext = (SecurityContext)mc.get((Object)SecurityContext.class.getName());
        }
        if (securityContext == null) {
            securityContext = (SecurityContext)mc.getContent(SecurityContext.class);
        }
        return securityContext;
    }

    @Override
    public UserSubject getSubjectById(long subjectId) {
        SecurityContext securityContext;
        MessageContextImpl mc = new MessageContextImpl(PhaseInterceptorChain.getCurrentMessage());
        UserSubject subject = (UserSubject)mc.getContent(UserSubject.class);
        if (subject == null && (securityContext = this.getSecurityContext((MessageContext)mc)) != null) {
            subject = OAuthUtil.newSubject(securityContext);
        }
        return subject;
    }
}

