/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.ClientProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.SubjectProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.ApplicationClient;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientFormData;
import org.eclipse.osee.jaxrs.server.security.JaxRsOAuthStorage;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;

public class ClientProviderImpl
implements ClientProvider {
    private static final int MAX_LOGOS = 10;
    private static final long EVICT_AFTER_30_MINS = 1800000L;
    private final LoadingCache<String, CachedOutputStream> logosCache;
    private final SubjectProvider subjectProvider;
    private final JaxRsOAuthStorage storage;

    public ClientProviderImpl(SubjectProvider subjectProvider, JaxRsOAuthStorage storage) {
        this.subjectProvider = subjectProvider;
        this.storage = storage;
        this.logosCache = ClientProviderImpl.newLogoCache(10, 1800000L);
    }

    @Override
    public long getClientId(Client client) {
        long clientUuid = -1L;
        if (client instanceof ApplicationClient) {
            ApplicationClient appClient = (ApplicationClient)client;
            clientUuid = appClient.getClientUuid();
        } else {
            String clientKey = client.getClientId();
            clientUuid = this.storage.getClientUuidByKey(clientKey);
        }
        return clientUuid;
    }

    @Override
    public Client getClient(String clientId) {
        OAuthClient data = this.storage.getClientByClientKey(clientId);
        ApplicationClient client = null;
        if (data != null) {
            UserSubject subject = this.subjectProvider.getSubjectById(data.getSubjectId());
            client = new ApplicationClient(data.getClientUuid(), data.getSubjectId(), (String)data.getGuid());
            client.setSubject(subject);
            client.setApplicationName(data.getApplicationName());
            client.setApplicationDescription(data.getApplicationDescription());
            client.setApplicationWebUri(data.getApplicationWebUri());
            client.setProperties(data.getProperties());
            client.setConfidential(data.isConfidential());
            client.setClientId(data.getClientId());
            client.setClientSecret(data.getClientSecret());
            client.setRegisteredAudiences(data.getRegisteredAudiences());
            client.setAllowedGrantTypes(data.getAllowedGrantTypes());
            client.setRegisteredScopes(data.getRegisteredScopes());
            client.setRedirectUris(data.getRedirectUris());
            client.setApplicationCertificates(data.getApplicationCertificates());
            client.setApplicationLogoUri(data.getApplicationLogoUri());
            client.setApplicationLogoSupplier(data.getApplicationLogoSupplier());
        }
        return client;
    }

    @Override
    public Client createClient(UriInfo uriInfo, OseePrincipal principal, final ClientFormData data) {
        String guid = (String)data.getGuid();
        long clientUuid = Lib.generateUuid();
        long subjectId = this.subjectProvider.getSubjectId(data.getUserSubject());
        ApplicationClient client = new ApplicationClient(clientUuid, subjectId, guid);
        client.setSubject(data.getUserSubject());
        client.setApplicationName(data.getName());
        client.setApplicationDescription(data.getDescription());
        client.setApplicationWebUri(data.getWebUri());
        client.setProperties(data.getProperties());
        client.setConfidential(data.isConfidential());
        String clientId = OAuthUtils.generateRandomTokenKey();
        client.setClientId(clientId);
        if (client.isConfidential()) {
            String clientSecret = OAuthUtils.generateRandomTokenKey();
            client.setClientSecret(clientSecret);
        }
        client.setRegisteredAudiences(data.getAllowedAudiences());
        client.setAllowedGrantTypes(data.getAllowedGrantTypes());
        client.setRegisteredScopes(data.getAllowedScopes());
        client.setRedirectUris(data.getRedirectUris());
        client.setApplicationCertificates(data.getCertificates());
        client.setApplicationLogoUri(data.getLogoUri());
        if (data.isLogoAvailable()) {
            ByteSource logoSupplier = new ByteSource(){

                public InputStream openStream() {
                    return data.getLogoContent();
                }
            };
            client.setApplicationLogoSupplier(logoSupplier);
        }
        this.storage.storeClient(principal, client);
        return client;
    }

    @Override
    public URI getClientLogoUri(UriInfo uriInfo, Client client) {
        String clientGuid;
        if (client instanceof ApplicationClient) {
            ApplicationClient appClient = (ApplicationClient)client;
            clientGuid = appClient.getGuid();
        } else {
            OAuthClient authClient = this.storage.getClientByClientKey(client.getClientId());
            clientGuid = (String)authClient.getGuid();
        }
        return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("client").path("{client-guid}").path("logo").build(new Object[]{clientGuid});
    }

    @Override
    public ByteSource getClientLogoSupplier(UriInfo uriInfo, String applicationGuid) {
        OAuthClient client = this.storage.getClientByClientGuid(applicationGuid);
        ByteSource supplier = null;
        if (client.hasApplicationLogoSupplier()) {
            supplier = client.getApplicationLogoSupplier();
        } else {
            String logoUri = client.getApplicationLogoUri();
            if (Strings.isValid((String)logoUri)) {
                supplier = this.newSupplier(logoUri);
            }
        }
        return supplier;
    }

    private ByteSource newSupplier(final String uri) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                CachedOutputStream cos;
                try {
                    cos = (CachedOutputStream)ClientProviderImpl.this.logosCache.get((Object)uri);
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex);
                }
                return cos.getInputStream();
            }
        };
    }

    private static LoadingCache<String, CachedOutputStream> newLogoCache(int cacheMaxSize, long cacheEvictTimeoutMillis) {
        return ClientProviderImpl.newCache(new CacheLoader<String, CachedOutputStream>(){

            public CachedOutputStream load(String uri) throws Exception {
                CachedOutputStream cos = new CachedOutputStream();
                BufferedInputStream inputStream = null;
                try {
                    URL url = new URL(uri);
                    inputStream = new BufferedInputStream(url.openStream());
                    IOUtils.copy((InputStream)inputStream, (OutputStream)cos);
                }
                catch (Throwable throwable) {
                    Lib.close(inputStream);
                    throw throwable;
                }
                Lib.close((AutoCloseable)inputStream);
                return cos;
            }
        }, cacheMaxSize, cacheEvictTimeoutMillis);
    }

    private static <K, V> LoadingCache<K, V> newCache(CacheLoader<K, V> loader, int cacheMaxSize, long cacheEvictTimeoutMillis) {
        return CacheBuilder.newBuilder().maximumSize((long)cacheMaxSize).expireAfterWrite(cacheEvictTimeoutMillis, TimeUnit.MILLISECONDS).build(loader);
    }
}

