/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writer.OwFactory;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwBranch;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;

public class OrcsWriterWorkbookGenerator {
    private final String[] instructionHeadings = new String[]{"Instructions and Settings", " "};
    private final String[] deleteSheetHeadings = new String[]{"Artifact Token - List Artifact Tokens for artifacts to delete"};
    private final String[] branchSheetHeadings = new String[]{"Branch Token - Copy one to Settings Sheet"};
    private final String[] artifactTokenSheetHeadings = new String[]{"Artifact Token - Copy for relations columns"};
    private final String[] artifactTypeSheetHeadings = new String[]{"Artifact Type - Copy for Artifact Type Columns"};
    private final String[] attributeTypeSheetHeadings = new String[]{"Attribute Type - Copy for Attribute Columns"};
    private final String[] relationTypeSheetHeadings = new String[]{"Relation Type - Copy for Relation Columns"};
    private final OwCollector collector;
    private final OrcsApi orcsApi;

    public OrcsWriterWorkbookGenerator(OwCollector collector, OrcsApi orcsApi) {
        this.collector = collector;
        this.orcsApi = orcsApi;
    }

    public void runOperation(OrcsApi providedOrcs, Writer providedWriter) throws IOException {
        ExcelXmlWriter writer = new ExcelXmlWriter(providedWriter);
        this.createInstructionSheet((ISheetWriter)writer);
        this.createCreateSheet((ISheetWriter)writer);
        this.createUpdateSheet((ISheetWriter)writer);
        this.createDeleteSheet((ISheetWriter)writer);
        this.createBranchSheet((ISheetWriter)writer);
        this.createArtifactTokenSheet((ISheetWriter)writer);
        this.createArtifactTypeSheet((ISheetWriter)writer);
        this.createAttributeTypeSheet((ISheetWriter)writer);
        this.createRelationTypeSheet((ISheetWriter)writer);
        writer.endWorkbook();
    }

    private void createInstructionSheet(ISheetWriter writer) throws IOException {
        writer.startSheet("Instructions and Settings", this.instructionHeadings.length);
        writer.writeRow((Object[])this.instructionHeadings);
        writer.writeCell(null);
        writer.endRow();
        writer.writeCell((Object)"Instructions");
        writer.endRow();
        String[] stringArray = this.collector.getInstructions().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            writer.writeCell((Object)line);
            writer.endRow();
            ++n2;
        }
        writer.writeCell(null);
        writer.endRow();
        writer.writeCell((Object)"Settings");
        writer.endRow();
        writer.writeCell((Object)"BRANCH TOKEN");
        writer.writeCell((Object)OwFactory.createBranchToken(CoreBranches.COMMON).getData());
        writer.endRow();
        writer.writeCell((Object)"AS USER ID");
        writer.writeCell((Object)SystemUser.OseeSystem.getUserId());
        writer.endRow();
        writer.writeCell((Object)"PERSIST COMMENT");
        writer.writeCell((Object)"Enter Persist Comment Here");
        writer.endRow();
        writer.endSheet();
    }

    private void createCreateSheet(ISheetWriter writer) throws IOException {
        Object[] objectArray = new String[6];
        objectArray[1] = "New Art Token (for refrence in relations, if needed)";
        objectArray[2] = "Name";
        objectArray[3] = "Attribute";
        objectArray[4] = "Attribute";
        objectArray[5] = "Relation";
        Object[] createSheetHeadings = objectArray;
        writer.startSheet("CREATE", createSheetHeadings.length);
        writer.writeRow(createSheetHeadings);
        writer.writeCell((Object)"Artifact Type Token");
        writer.writeCell(null);
        writer.writeCell((Object)(String.valueOf(CoreAttributeTypes.Name.getName()) + " (required)"));
        writer.writeCell((Object)OwFactory.createAttributeType((AttributeTypeToken)CoreAttributeTypes.StaticId).getData());
        writer.writeCell((Object)OwFactory.createAttributeType((AttributeTypeToken)CoreAttributeTypes.Partition).getData());
        writer.writeCell((Object)OwFactory.createRelationType(this.orcsApi, CoreRelationTypes.Default_Hierarchical__Parent).getData());
        writer.endRow();
        writer.writeCell((Object)OwFactory.createArtifactType(CoreArtifactTypes.Folder).getData());
        Long folderUuid = Lib.generateArtifactIdAsInt();
        OwArtifactToken folderToken = OwFactory.createArtifactToken("Orcs Writer Import Folder", folderUuid);
        writer.writeCell((Object)folderToken.getData());
        writer.writeCell((Object)"Orcs Writer Import Folder");
        writer.writeCell(null);
        writer.writeCell(null);
        writer.writeCell((Object)OwFactory.createArtifactToken(CoreArtifactTokens.DefaultHierarchyRoot).getData());
        writer.endRow();
        writer.writeCell((Object)OwFactory.createArtifactType(CoreArtifactTypes.SoftwareRequirement).getData());
        writer.writeCell(null);
        writer.writeCell((Object)"Software Requirement 1");
        writer.writeCell((Object)"static id field 1");
        writer.writeCell((Object)"Communication");
        writer.writeCell((Object)folderToken.getData());
        writer.endRow();
        writer.writeCell((Object)OwFactory.createArtifactType(CoreArtifactTypes.SoftwareRequirement).getData());
        writer.writeCell(null);
        writer.writeCell((Object)"Software Requirement 2");
        writer.writeCell((Object)"static id field 2");
        writer.writeCell((Object)"Flight Control");
        writer.writeCell((Object)folderToken.getData());
        writer.endRow();
        writer.endSheet();
    }

    private void createUpdateSheet(ISheetWriter writer) throws IOException {
        Object[] objectArray = new String[4];
        objectArray[1] = "Name";
        objectArray[2] = "Attribute";
        objectArray[3] = "Attribute";
        Object[] updateSheetHeadings = objectArray;
        writer.startSheet("UPDATE", updateSheetHeadings.length);
        writer.writeRow(updateSheetHeadings);
        writer.writeCell((Object)"Artifact Token");
        writer.writeCell((Object)CoreAttributeTypes.Name.getName());
        writer.writeCell((Object)OwFactory.createAttributeType((AttributeTypeToken)CoreAttributeTypes.StaticId).getData());
        writer.writeCell((Object)OwFactory.createAttributeType((AttributeTypeToken)CoreAttributeTypes.Annotation).getData());
        writer.endRow();
        writer.writeCell((Object)OwFactory.createArtifactToken(CoreArtifactTokens.UserGroups).getData());
        writer.writeCell((Object)CoreArtifactTokens.UserGroups.getName());
        writer.writeCell((Object)"test static id");
        writer.writeCell((Object)"test annotation");
        writer.endRow();
        writer.endSheet();
    }

    private void createDeleteSheet(ISheetWriter writer) throws IOException {
        writer.startSheet("DELETE", this.deleteSheetHeadings.length);
        writer.writeRow((Object[])this.deleteSheetHeadings);
        writer.endSheet();
    }

    private void createBranchSheet(ISheetWriter writer) throws IOException {
        writer.startSheet("Branch Token", this.branchSheetHeadings.length);
        writer.writeRow((Object[])this.branchSheetHeadings);
        for (OwBranch token : this.collector.getBranches()) {
            writer.writeCell((Object)token.getData());
            writer.endRow();
        }
        writer.endSheet();
    }

    private void createArtifactTokenSheet(ISheetWriter writer) throws IOException {
        writer.startSheet("Artifact Token", this.artifactTokenSheetHeadings.length);
        writer.writeRow((Object[])this.artifactTokenSheetHeadings);
        for (OwArtifactToken token : this.collector.getArtTokens()) {
            writer.writeCell((Object)token.getData());
            writer.endRow();
        }
        writer.endSheet();
    }

    private void createArtifactTypeSheet(ISheetWriter writer) throws IOException {
        writer.startSheet("Artifact Types", this.artifactTypeSheetHeadings.length);
        writer.writeRow((Object[])this.artifactTypeSheetHeadings);
        for (OwArtifactType type : this.collector.getArtTypes()) {
            writer.writeCell((Object)type.getData());
            writer.endRow();
        }
        writer.endSheet();
    }

    private void createAttributeTypeSheet(ISheetWriter writer) throws IOException {
        writer.startSheet("Attribute Types", this.attributeTypeSheetHeadings.length);
        writer.writeRow((Object[])this.attributeTypeSheetHeadings);
        for (OwAttributeType type : this.collector.getAttrTypes()) {
            writer.writeCell((Object)type.getData());
            writer.endRow();
        }
        writer.endSheet();
    }

    private void createRelationTypeSheet(ISheetWriter writer) throws IOException {
        writer.startSheet("Relation Types", this.relationTypeSheetHeadings.length);
        writer.writeRow((Object[])this.relationTypeSheetHeadings);
        for (OwRelationType relation : this.collector.getRelTypes()) {
            writer.writeCell((Object)relation.getData());
            writer.endRow();
        }
        writer.endSheet();
    }
}

