/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.console;

import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ServerShutdownCommand
implements ConsoleCommand {
    private IApplicationServerManager appManager;

    public void setApplicationServerManager(IApplicationServerManager appManager) {
        this.appManager = appManager;
    }

    private IApplicationServerManager getApplicationServerManager() {
        return this.appManager;
    }

    public String getName() {
        return "server_shutdown";
    }

    public String getDescription() {
        return "Shutdown server instance";
    }

    public String getUsage() {
        return "[oseeOnly=<TRUE|FALSE>] - To shutdown only the osee server instance without shutting down OSGI framework\n                        - Shutsdown both osee server instance and OSGI framework\n";
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        return new ServerShutdownCallable(this.getApplicationServerManager(), console, params);
    }

    private static final class ServerShutdownCallable
    implements Callable<Boolean> {
        private final Console console;
        private final ConsoleParameters parameters;
        private final IApplicationServerManager manager;

        public ServerShutdownCallable(IApplicationServerManager manager, Console console, ConsoleParameters parameters) {
            this.manager = manager;
            this.console = console;
            this.parameters = parameters;
        }

        @Override
        public Boolean call() throws Exception {
            while (!this.manager.isSystemIdle()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    this.console.write((Throwable)ex);
                }
            }
            this.manager.shutdown();
            if (this.parameters.getBoolean("oseeOnly")) {
                this.console.writeln((Object)"Osee Shutdown Complete");
            } else {
                Bundle thisBundle = FrameworkUtil.getBundle(this.getClass());
                Bundle frameworkBundle = thisBundle.getBundleContext().getBundle(0L);
                frameworkBundle.stop();
            }
            return Boolean.TRUE;
        }
    }
}

