/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl;

import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osee.framework.core.dsl.OseeDslResource;
import org.eclipse.osee.framework.core.dsl.OseeDslStandaloneSetup;
import org.eclipse.osee.framework.core.dsl.internal.OseeDslResourceImpl;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDsl;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public final class OseeDslResourceUtil {
    private OseeDslResourceUtil() {
    }

    public static OseeDslResource loadModelUnchecked(String uri, InputStream xTextData) throws Exception {
        xTextData = OseeDslResourceUtil.upConvertTo17(xTextData);
        OseeDslStandaloneSetup setup = new OseeDslStandaloneSetup();
        Injector injector = setup.createInjectorAndDoEMFRegistration();
        XtextResourceSet set = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        set.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        Resource resource = set.createResource(URI.createURI((String)uri));
        Map loadOptions = set.getLoadOptions();
        resource.load(xTextData, loadOptions);
        OseeDslResourceImpl displayLogicResource = new OseeDslResourceImpl(resource);
        return displayLogicResource;
    }

    public static OseeDslResource loadModelUnchecked(String uri, String xTextData) throws Exception {
        return OseeDslResourceUtil.loadModelUnchecked(uri, new ByteArrayInputStream(xTextData.getBytes("UTF-8")));
    }

    public static InputStream upConvertTo17(InputStream inputStream) throws Exception {
        String typesStr = Lib.inputStreamToString((InputStream)inputStream);
        return new ByteArrayInputStream(typesStr.getBytes("UTF-8"));
    }

    public static OseeDslResource loadModel(String uri, String xTextData) throws Exception {
        OseeDslResource displayLogicResource = OseeDslResourceUtil.loadModelUnchecked(uri, xTextData);
        OseeDslResourceUtil.checkErrorsEmpty(uri, displayLogicResource.getErrors());
        return displayLogicResource;
    }

    public static OseeDslResource loadModel(String uri, InputStream xTextData) throws Exception {
        OseeDslResource displayLogicResource = OseeDslResourceUtil.loadModelUnchecked(uri, xTextData);
        OseeDslResourceUtil.checkErrorsEmpty(uri, displayLogicResource.getErrors());
        return displayLogicResource;
    }

    public static void saveModel(OseeDslResource dslResource, OutputStream outputStream, boolean compressOnSave) throws Exception {
        if (!(dslResource instanceof OseeDslResourceImpl)) {
            throw new IllegalArgumentException(String.format("Unsupported dslResource class [%s]", dslResource != null ? dslResource.getClass() : "null"));
        }
        OseeDslResourceImpl resourceImpl = (OseeDslResourceImpl)dslResource;
        Resource resource = resourceImpl.getResource();
        OseeDslResourceUtil.saveResource(resource, outputStream, compressOnSave);
    }

    public static void saveModel(OseeDsl model, String uri, OutputStream outputStream, boolean compressOnSave) throws Exception {
        OseeDslStandaloneSetup.doSetup();
        XtextResourceSet resourceSet = new XtextResourceSet();
        Resource resource = resourceSet.createResource(URI.createURI((String)uri));
        resource.getContents().add((Object)model);
        OseeDslResourceUtil.saveResource(resource, outputStream, compressOnSave);
    }

    private static void saveResource(Resource resource, OutputStream outputStream, boolean compressOnSave) throws Exception {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (compressOnSave) {
            options.put("ZIP", Boolean.TRUE);
        }
        SaveOptions saveOptions = SaveOptions.getOptions(options);
        resource.save(outputStream, saveOptions.toOptionsMap());
    }

    private static void checkErrorsEmpty(String uri, Collection<String> errors) throws Exception {
        if (errors != null && !errors.isEmpty()) {
            throw new IllegalStateException(String.format("Error loading Orcs Types Model from uri [%s]\n\n%s", uri, errors.iterator().next()));
        }
    }
}

