/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.workingsets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class TaskWorkingSetAdapterFactory
implements IAdapterFactory {
    private static final String TASK_ELEMENT_FACTORY_ID = "org.eclipse.mylyn.tasks.ui.workingSets.elementFactory";
    private static final Class[] ADAPTER_TYPES = new Class[]{IPersistableElement.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_TYPES;
    }

    public <T> T getAdapter(final Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IPersistableElement.class && adaptableObject instanceof AbstractTaskContainer) {
            return adapterType.cast(new IPersistableElement(){

                public void saveState(IMemento memento) {
                    IRepositoryElement container = (IRepositoryElement)adaptableObject;
                    memento.putString("handle.task", container.getHandleIdentifier());
                }

                public String getFactoryId() {
                    return TaskWorkingSetAdapterFactory.TASK_ELEMENT_FACTORY_ID;
                }
            });
        }
        if (adapterType == IPersistableElement.class && adaptableObject instanceof IProject) {
            return adapterType.cast(new IPersistableElement(){

                public void saveState(IMemento memento) {
                    IProject project = (IProject)adaptableObject;
                    memento.putString("handle.project", project.getName());
                }

                public String getFactoryId() {
                    return TaskWorkingSetAdapterFactory.TASK_ELEMENT_FACTORY_ID;
                }
            });
        }
        return null;
    }
}

