/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.image;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMProperty;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelFinder;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelUtil;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSValue;

public class CSSImageType {
    private final String fName;
    public static final CSSImageType STYLESHEET = new CSSImageType("STYLESHEET");
    public static final CSSImageType RULE_CHARSET = new CSSImageType("RULE_CHARSET");
    public static final CSSImageType RULE_FONTFACE = new CSSImageType("RULE_FONTFACE");
    public static final CSSImageType RULE_IMPORT = new CSSImageType("RULE_IMPORT");
    public static final CSSImageType RULE_MEDIA = new CSSImageType("RULE_MEDIA");
    public static final CSSImageType RULE_PAGE = new CSSImageType("RULE_PAGE");
    public static final CSSImageType RULE_STYLE = new CSSImageType("RULE_STYLE");
    public static final CSSImageType RULE_UNKNOWN = new CSSImageType("RULE_UNKNOWN");
    public static final CSSImageType SELECTOR_CLASS = new CSSImageType("SELECTOR_CLASS");
    public static final CSSImageType SELECTOR_ID = new CSSImageType("SELECTOR_ID");
    public static final CSSImageType SELECTOR_DEFAULT = new CSSImageType("SELECTOR_DEFAULT");
    public static final CSSImageType SELECTOR_PSEUDO = new CSSImageType("SELECTOR_PSEUDO");
    public static final CSSImageType SELECTOR_TAG = new CSSImageType("SELECTOR_TAG");
    public static final CSSImageType SELECTOR_LINK = new CSSImageType("SELECTOR_LINK");
    public static final CSSImageType VALUE_FUNCTION = new CSSImageType("VALUE_FUNCTION");
    public static final CSSImageType VALUE_NUMBER = new CSSImageType("VALUE_NUMBER");
    public static final CSSImageType VALUE_STRING = new CSSImageType("VALUE_STRING");
    public static final CSSImageType CATEGORY_AURAL = new CSSImageType("CATEGORY_AURAL");
    public static final CSSImageType CATEGORY_BOX = new CSSImageType("CATEGORY_BOX");
    public static final CSSImageType CATEGORY_COLORANDBACKGROUND = new CSSImageType("CATEGORY_COLORANDBACKGROUND");
    public static final CSSImageType CATEGORY_CONTENT = new CSSImageType("CATEGORY_CONTENT");
    public static final CSSImageType CATEGORY_FONT = new CSSImageType("CATEGORY_FONT");
    public static final CSSImageType CATEGORY_PAGE = new CSSImageType("CATEGORY_PAGE");
    public static final CSSImageType CATEGORY_TABLES = new CSSImageType("CATEGORY_TABLES");
    public static final CSSImageType CATEGORY_TEXT = new CSSImageType("CATEGORY_TEXT");
    public static final CSSImageType CATEGORY_UI = new CSSImageType("CATEGORY_UI");
    public static final CSSImageType CATEGORY_VISUAL = new CSSImageType("CATEGORY_VISUAL");
    public static final CSSImageType CATEGORY_DEFAULT = new CSSImageType("CATEGORY_DEFAULT");
    private static Map fCategoryMap = null;

    private CSSImageType(String name) {
        this.fName = name;
    }

    public String toString() {
        return this.fName;
    }

    public static CSSImageType getImageType(ICSSNode node) {
        CSSImageType imageType = null;
        if (node instanceof CSSCharsetRule) {
            imageType = RULE_CHARSET;
        } else if (node instanceof CSSFontFaceRule) {
            imageType = RULE_FONTFACE;
        } else if (node instanceof CSSImportRule) {
            imageType = RULE_IMPORT;
        } else if (node instanceof CSSMediaRule) {
            imageType = RULE_MEDIA;
        } else if (node instanceof CSSPageRule) {
            imageType = RULE_PAGE;
        } else if (node instanceof CSSStyleRule) {
            imageType = CSSImageType.getImageType(((ICSSStyleRule)node).getSelectors());
        } else if (node instanceof CSSStyleDeclaration) {
            ICSSNode parent = node.getParentNode();
            if (parent != null) {
                return CSSImageType.getImageType(parent);
            }
        } else if (node instanceof ICSSStyleDeclItem) {
            String name = ((ICSSStyleDeclItem)node).getPropertyName();
            ICSSDocument doc = node.getOwnerDocument();
            ICSSModel model = doc != null ? doc.getModel() : null;
            CSSMetaModelFinder finder = CSSMetaModelFinder.getInstance();
            CSSMetaModel metaModel = finder.findMetaModelFor((IStructuredModel)model);
            ICSSNode parent = node.getParentNode();
            if (parent != null && (parent = parent.getParentNode()) instanceof CSSFontFaceRule) {
                imageType = CATEGORY_FONT;
            }
            if (imageType == null) {
                CSSMMProperty prop = new CSSMetaModelUtil(metaModel).getProperty(name);
                if (prop != null) {
                    String category = prop.getAttribute("category");
                    imageType = CSSImageType.getImageType(category);
                }
                if (imageType == null) {
                    imageType = CATEGORY_DEFAULT;
                }
            }
        } else if (node instanceof CSSValue) {
            switch (((CSSValue)node).getCssValueType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 26: 
                case 27: {
                    imageType = VALUE_NUMBER;
                    break;
                }
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 29: 
                case 30: {
                    imageType = VALUE_FUNCTION;
                    break;
                }
                default: {
                    imageType = VALUE_STRING;
                }
            }
        }
        return imageType;
    }

    public static CSSImageType getImageType(ICSSSelectorList selectorList) {
        if (selectorList == null || selectorList.getLength() == 0) {
            return SELECTOR_DEFAULT;
        }
        CSSImageType imageType = null;
        int nSelectors = selectorList.getLength();
        int i = 0;
        while (i < nSelectors) {
            CSSImageType candidate = CSSImageType.getImageType(selectorList.getSelector(i));
            if (imageType == null) {
                imageType = candidate;
            } else if (imageType != candidate) {
                imageType = null;
                break;
            }
            ++i;
        }
        return imageType == null ? SELECTOR_DEFAULT : imageType;
    }

    public static CSSImageType getImageType(ICSSSelector selector) {
        CSSImageType imageType = SELECTOR_DEFAULT;
        if (selector == null || selector.getLength() == 0) {
            return imageType;
        }
        ICSSSelectorItem item = selector.getItem(selector.getLength() - 1);
        if (item.getItemType() == 1) {
            ICSSSimpleSelector ss = (ICSSSimpleSelector)item;
            imageType = ss.getNumOfIDs() > 0 ? SELECTOR_ID : (ss.getNumOfClasses() > 0 ? SELECTOR_CLASS : (ss.getNumOfPseudoNames() > 0 ? SELECTOR_PSEUDO : SELECTOR_TAG));
        }
        return imageType;
    }

    public static CSSImageType getImageType(String category) {
        CSSImageType imageType;
        if (fCategoryMap == null) {
            fCategoryMap = new HashMap();
            fCategoryMap.put("aural", CATEGORY_AURAL);
            fCategoryMap.put("box", CATEGORY_BOX);
            fCategoryMap.put("colorandbackground", CATEGORY_COLORANDBACKGROUND);
            fCategoryMap.put("content", CATEGORY_CONTENT);
            fCategoryMap.put("font", CATEGORY_FONT);
            fCategoryMap.put("page", CATEGORY_PAGE);
            fCategoryMap.put("tables", CATEGORY_TABLES);
            fCategoryMap.put("text", CATEGORY_TEXT);
            fCategoryMap.put("ui", CATEGORY_UI);
            fCategoryMap.put("visual", CATEGORY_VISUAL);
        }
        return (imageType = (CSSImageType)fCategoryMap.get(category)) == null ? CATEGORY_DEFAULT : imageType;
    }
}

