/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import java.util.Arrays;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.color.CSSColorManager;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class ColorPropertyMeta
extends CSSPropertyMeta {
    private static final Object DEFAULT_COLOR = ColorConstants.black;
    private static final String[] KEYWORDS = new String[0];
    private static final String[] NOTSUPPORT_TAG = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};

    public ColorPropertyMeta() {
        super(true, DEFAULT_COLOR);
    }

    @Override
    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        String text = value.getCssText();
        Object result = CSSColorManager.getInstance().getColor(text);
        if (result != null) {
            return result;
        }
        return this.getInitialValue(propertyName, style);
    }

    @Override
    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    @Override
    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        if (Arrays.asList(NOTSUPPORT_TAG).contains(htmltag.toLowerCase())) {
            return null;
        }
        String colorAttr = null;
        if ("color".equalsIgnoreCase(propertyName) && (colorAttr = DOMUtil.getAttributeIgnoreCase(element, "color")) == null && element.getLocalName().equalsIgnoreCase("body")) {
            colorAttr = DOMUtil.getAttributeIgnoreCase(element, "text");
        }
        if (colorAttr != null) {
            colorAttr = colorAttr.trim();
            Object result = CSSColorManager.getInstance().getColor(colorAttr);
            return result;
        }
        return null;
    }
}

