/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.ui.internal.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.resource.jaxbprops.JaxbPropertiesResource;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.plugin.JptJaxbEclipseLinkUiPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class AddEclipseLinkJaxbPropertyCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        IWorkbenchWindow activeWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        Iterator stream = selection.iterator();
        while (stream.hasNext()) {
            this.addEclipseLinkJaxbProperty(stream.next(), activeWindow);
        }
        return null;
    }

    protected void addEclipseLinkJaxbProperty(Object selectedObject, IWorkbenchWindow activeWindow) {
        JaxbPackage jaxbPackage = (JaxbPackage)Platform.getAdapterManager().getAdapter(selectedObject, JaxbPackage.class);
        JaxbPropertiesResource jaxbProperties = jaxbPackage.getJaxbProject().getJaxbPropertiesResource(jaxbPackage.getName());
        if (jaxbProperties == null) {
            this.createJaxbPropertiesWithProperty(jaxbPackage, activeWindow);
        } else {
            this.addPropertyToExistingProperties(jaxbPackage, activeWindow);
        }
    }

    protected void createJaxbPropertiesWithProperty(JaxbPackage jaxbPackage, final IWorkbenchWindow activeWindow) {
        IFolder folder;
        try {
            folder = this.getFolder(jaxbPackage);
        }
        catch (JavaModelException jme) {
            JptJaxbEclipseLinkUiPlugin.instance().logError(jme);
            return;
        }
        Job job = new Job("Creating jaxb.properties"){

            protected IStatus run(IProgressMonitor monitor) {
                IFile file = folder.getFile("jaxb.properties");
                InputStream stream = AddEclipseLinkJaxbPropertyCommandHandler.this.createInputStream(AddEclipseLinkJaxbPropertyCommandHandler.this.createNewProperties());
                try {
                    file.create(stream, true, null);
                }
                catch (CoreException ce) {
                    JptJaxbEclipseLinkUiPlugin.instance().logError(ce);
                    return JptJaxbEclipseLinkUiPlugin.instance().buildErrorStatus(ce, "Could not create jaxb.properties.");
                }
                AddEclipseLinkJaxbPropertyCommandHandler.this.revealAndOpenFile(file, activeWindow);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)folder);
        job.schedule();
    }

    protected void addPropertyToExistingProperties(JaxbPackage jaxbPackage, final IWorkbenchWindow activeWindow) {
        IFolder folder;
        try {
            folder = this.getFolder(jaxbPackage);
        }
        catch (JavaModelException jme) {
            JptJaxbEclipseLinkUiPlugin.instance().logError(jme);
            return;
        }
        Job job = new Job("Adding property to jaxb.properties."){

            protected IStatus run(IProgressMonitor monitor) {
                IFile file = folder.getFile("jaxb.properties");
                Properties properties = AddEclipseLinkJaxbPropertyCommandHandler.this.loadProperties(file);
                if (properties == null) {
                    return JptJaxbEclipseLinkUiPlugin.instance().buildErrorStatus("Could not load jaxb.properties.");
                }
                AddEclipseLinkJaxbPropertyCommandHandler.this.adjustProperties(properties);
                InputStream stream = AddEclipseLinkJaxbPropertyCommandHandler.this.createInputStream(properties);
                try {
                    file.setContents(stream, true, true, null);
                }
                catch (CoreException ce) {
                    JptJaxbEclipseLinkUiPlugin.instance().logError(ce);
                    return JptJaxbEclipseLinkUiPlugin.instance().buildErrorStatus(ce, "Could not load jaxb.properties.");
                }
                AddEclipseLinkJaxbPropertyCommandHandler.this.revealAndOpenFile(file, activeWindow);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)folder);
        job.schedule();
    }

    protected IFolder getFolder(JaxbPackage jaxbPackage) throws JavaModelException {
        IPackageFragment[] iPackageFragmentArray = jaxbPackage.getJaxbProject().getJavaProject().getPackageFragments();
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment pkgFragment = iPackageFragmentArray[n2];
            if (pkgFragment.getElementName().equals(jaxbPackage.getName())) {
                return (IFolder)pkgFragment.getUnderlyingResource();
            }
            ++n2;
        }
        return null;
    }

    protected Properties createNewProperties() {
        Properties properties = new Properties();
        this.adjustProperties(properties);
        return properties;
    }

    protected Properties loadProperties(IFile file) {
        Properties properties = new Properties();
        Closeable stream = null;
        try {
            try {
                properties.load(file.getContents());
            }
            catch (Exception ex) {
                JptJaxbEclipseLinkUiPlugin.instance().logError(ex);
                this.closeStream(stream);
                return null;
            }
        }
        finally {
            this.closeStream(stream);
        }
        return properties;
    }

    protected void adjustProperties(Properties properties) {
        String factoryProp = "javax.xml.bind.context.factory";
        String factoryPropValue = "org.eclipse.persistence.jaxb.JAXBContextFactory";
        properties.setProperty(factoryProp, factoryPropValue);
    }

    protected InputStream createInputStream(Properties properties) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            try {
                properties.store(outStream, null);
            }
            catch (Exception e) {
                JptJaxbEclipseLinkUiPlugin.instance().logError(e);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                this.closeStream(outStream);
                return byteArrayInputStream;
            }
        }
        finally {
            this.closeStream(outStream);
        }
        return new ByteArrayInputStream(outStream.toByteArray());
    }

    protected void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            JptJaxbEclipseLinkUiPlugin.instance().logError(ex);
        }
    }

    protected void revealAndOpenFile(final IFile file, final IWorkbenchWindow activeWindow) {
        UIJob job = new UIJob("Opening jaxb.properties."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)activeWindow);
                try {
                    IDE.openEditor((IWorkbenchPage)activeWindow.getActivePage(), (IFile)file, (boolean)true);
                }
                catch (PartInitException pie) {
                    JptJaxbEclipseLinkUiPlugin.instance().logError(pie);
                    return JptJaxbEclipseLinkUiPlugin.instance().buildErrorStatus(pie, "Could not open jaxb.properties in editor.");
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)file.getParent());
        job.schedule();
    }
}

