/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AxisCheckCompilerLevelCommand
extends AbstractDataModelOperation {
    private String serverProject_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IProject project;
        IJavaProject javaProject;
        IStatus status = Status.OK_STATUS;
        String javaSpecVersion = System.getProperty("java.specification.version");
        if (javaSpecVersion != null && (javaProject = JavaCore.create((IProject)(project = ProjectUtilities.getProject((String)this.serverProject_)))) != null) {
            String projectCompilerLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", false);
            if (projectCompilerLevel == null) {
                projectCompilerLevel = (String)JavaCore.getDefaultOptions().get("org.eclipse.jdt.core.compiler.compliance");
            }
            if (projectCompilerLevel != null && !this.compilerLevelsCompatible(javaSpecVersion, projectCompilerLevel)) {
                status = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_COMPILER_LEVEL_NOT_COMPATIBLE, (Object[])new String[]{javaSpecVersion, this.serverProject_, projectCompilerLevel}));
                this.getEnvironment().getStatusHandler().reportError(status);
            }
        }
        return status;
    }

    private boolean compilerLevelsCompatible(String javaSpecVersion, String projectCompilerLevel) {
        return javaSpecVersion.compareTo(projectCompilerLevel) >= 0;
    }

    public void setServerProject(String serverProject) {
        this.serverProject_ = serverProject;
    }
}

