/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public final class MOXySystemProperties {
    public static final String XML_ID_EXTENSION = "org.eclipse.persistence.moxy.annotation.xml-id-extension";
    public static final String XML_VALUE_EXTENSION = "org.eclipse.persistence.moxy.annotation.xml-value-extension";
    public static final String JSON_TYPE_COMPATIBILITY = "org.eclipse.persistence.json.type-compatibility";
    public static final String JSON_USE_XSD_TYPES_PREFIX = "org.eclipse.persistence.json.use-xsd-types-prefix";
    public static final Boolean xmlIdExtension = MOXySystemProperties.getBoolean("org.eclipse.persistence.moxy.annotation.xml-id-extension");
    public static final Boolean xmlValueExtension = MOXySystemProperties.getBoolean("org.eclipse.persistence.moxy.annotation.xml-value-extension");
    public static final Boolean jsonTypeCompatibility = MOXySystemProperties.getBoolean("org.eclipse.persistence.json.type-compatibility");
    public static final Boolean jsonUseXsdTypesPrefix = MOXySystemProperties.getBoolean("org.eclipse.persistence.json.use-xsd-types-prefix");

    private MOXySystemProperties() {
    }

    private static Boolean getBoolean(String propertyName) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return MOXySystemProperties.runDoPrivileged(propertyName);
        }
        return MOXySystemProperties.getSystemPropertyValue(propertyName);
    }

    private static Boolean runDoPrivileged(final String propertyName) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return MOXySystemProperties.getSystemPropertyValue(propertyName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private static Boolean getSystemPropertyValue(String propertyName) {
        return Boolean.getBoolean(propertyName);
    }
}

