/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown.internal.phrase;

import java.util.Set;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class ExtendedAutomaticLinkReplacementToken
extends PatternBasedElement {
    private static final String AUTOMATIC_LINK_REGEX = "(?<=^|\\s|\\p{Punct})((https?://(?!/)|www\\.)[a-zA-Z0-9:/?#\\[\\]@!$&'\\(\\)\\*+,;=\\-\\._~%]+)(?=$|\"|\\s|<)";
    private static final Set<String> EMPTY_LINKS = Set.of("www.", "http://", "https://");

    protected String getPattern(int groupOffset) {
        return AUTOMATIC_LINK_REGEX;
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new PatternBasedElementProcessor(){

            public void emit() {
                String href = this.group(1);
                int parensBalance = href.codePoints().map(c -> switch (c) {
                    case 40 -> -1;
                    case 41 -> 1;
                    default -> 0;
                }).sum();
                int endIndex = -1;
                int i = href.length() - 1;
                block5: while (i > 3) {
                    switch (href.charAt(i)) {
                        case '!': 
                        case '\"': 
                        case '\'': 
                        case '*': 
                        case '.': 
                        case ':': 
                        case '?': 
                        case '_': 
                        case '~': {
                            endIndex = i;
                            break;
                        }
                        case ')': {
                            if (parensBalance <= 0) break block5;
                            --parensBalance;
                        }
                        case ';': {
                            endIndex = i = this.skipHtmlEntity(href, i);
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    --i;
                }
                String linkText = endIndex > -1 ? href.substring(0, endIndex) : href;
                Object linkHref = linkText.startsWith("www.") ? "http://" + linkText : linkText;
                if (EMPTY_LINKS.contains(linkText)) {
                    this.builder.characters(href);
                } else {
                    this.builder.link((String)linkHref, linkText);
                    if (endIndex > -1) {
                        this.builder.characters(href.substring(endIndex));
                    }
                }
            }

            private int skipHtmlEntity(String href, int endIndex) {
                int i = endIndex - 1;
                while (i > 3) {
                    boolean isAlphaNum;
                    char c = href.charAt(i);
                    boolean bl = isAlphaNum = this.inRange(c, 'a', 'z') || this.inRange(c, 'A', 'Z') || this.inRange(c, '0', '9');
                    if (c == '&') {
                        return i;
                    }
                    if (!isAlphaNum) {
                        return endIndex;
                    }
                    --i;
                }
                return endIndex;
            }

            private boolean inRange(char toCheck, char lowerBound, char upperBound) {
                return toCheck >= lowerBound && toCheck <= upperBound;
            }
        };
    }
}

