/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.launch.BuildDockerImageUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class DockerComposeUpLaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private ComboViewer connectionSelectionComboViewer;
    private Text dockerComposeWorkingDirPathText;
    private boolean dockerComposeFilePathWorkspaceRelative;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
        this.setControl((Control)container);
        Group connectionGroup = new Group(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)connectionGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)connectionGroup);
        connectionGroup.setText(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.connection.group.label"));
        connectionGroup.setToolTipText(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.connection.group.tooltip"));
        Combo connectionSelectionCombo = new Combo((Composite)connectionGroup, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)connectionSelectionCombo);
        this.connectionSelectionComboViewer = new ComboViewer(connectionSelectionCombo);
        this.connectionSelectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.connectionSelectionComboViewer.setInput((Object)DockerConnectionManager.getInstance().getConnectionNames());
        connectionSelectionCombo.addSelectionListener((SelectionListener)new LaunchConfigurationChangeListener());
        this.createDockerComposeWorkingDirLocationGroup(container);
    }

    private void createDockerComposeWorkingDirLocationGroup(Composite container) {
        Group dockerComposeWorkingDirLocationGroup = new Group(container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)dockerComposeWorkingDirLocationGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(3).applyTo((Composite)dockerComposeWorkingDirLocationGroup);
        dockerComposeWorkingDirLocationGroup.setText(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.dockerComposePath.group.label"));
        this.dockerComposeWorkingDirPathText = new Text((Composite)dockerComposeWorkingDirLocationGroup, 2048);
        this.dockerComposeWorkingDirPathText.addModifyListener((ModifyListener)new LaunchConfigurationChangeListener());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)this.dockerComposeWorkingDirPathText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)new Label((Composite)dockerComposeWorkingDirLocationGroup, 0));
        Button browseWorkspaceButton = new Button((Composite)dockerComposeWorkingDirLocationGroup, 0);
        browseWorkspaceButton.setText(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.dockerComposePath.browseworkspace.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)browseWorkspaceButton);
        browseWorkspaceButton.addSelectionListener(this.onBrowseWorkspace(this.dockerComposeWorkingDirPathText, IContainer.class));
        Button browseFileSystemButton = new Button((Composite)dockerComposeWorkingDirLocationGroup, 0);
        browseFileSystemButton.setText(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.dockerComposePath.browsefilesystem.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)browseFileSystemButton);
        browseFileSystemButton.addSelectionListener(this.onBrowseFileSystemForDirectory(this.dockerComposeWorkingDirPathText));
    }

    private SelectionListener onBrowseWorkspace(Text pathText, Class<?> expectedType) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setTitle(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.dockerComposePath.browseworkspace.dialog.title"));
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            dialog.setAllowMultiple(false);
            dialog.setValidator(selection -> {
                if (selection.length == 1 && expectedType.isAssignableFrom(selection[0].getClass())) {
                    return Status.OK_STATUS;
                }
                return Status.error(null);
            });
            if (dialog.open() == 0) {
                IResource selection2 = (IResource)dialog.getFirstResult();
                pathText.setText(selection2.getFullPath().toOSString());
                this.dockerComposeFilePathWorkspaceRelative = true;
            }
        });
    }

    private SelectionListener onBrowseFileSystemForDirectory(Text pathText) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            String selection = dialog.open();
            if (selection != null) {
                pathText.setText(selection);
                this.dockerComposeFilePathWorkspaceRelative = false;
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.connectionSelectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)configuration.getAttribute("dockerConnection", "")));
            this.dockerComposeWorkingDirPathText.setText(configuration.getAttribute("workingDir", ""));
            this.dockerComposeFilePathWorkspaceRelative = configuration.getAttribute("workingDirWorkspaceRelativeLocation", false);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String dockerConnection = launchConfig.getAttribute("dockerConnection", "");
            String sourcePathLocation = launchConfig.getAttribute("workingDir", "");
            boolean sourcePathWorkspaceRelativeLocation = launchConfig.getAttribute("workingDirWorkspaceRelativeLocation", false);
            IPath sourcePath = BuildDockerImageUtils.getPath(sourcePathLocation, sourcePathWorkspaceRelativeLocation);
            if (dockerConnection.isEmpty() || dockerConnection == null || DockerConnectionManager.getInstance().findConnection(dockerConnection) == null) {
                this.setErrorMessage(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.connection.missing"));
                return false;
            }
            if (sourcePathLocation.isEmpty() || sourcePath == null) {
                this.setErrorMessage(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.dockerComposePath.missing"));
                return false;
            }
            if (!sourcePath.append("docker-compose.yml").toFile().exists()) {
                this.setErrorMessage(LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.dockerComposePath.missingDockerComposeFile"));
                return false;
            }
            this.setErrorMessage(null);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return super.isValid(launchConfig);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IStructuredSelection connectionSelection = this.connectionSelectionComboViewer.getStructuredSelection();
        if (connectionSelection.getFirstElement() != null) {
            configuration.setAttribute("dockerConnection", connectionSelection.getFirstElement().toString());
        }
        configuration.setAttribute("workingDir", this.dockerComposeWorkingDirPathText.getText());
        configuration.setAttribute("workingDirWorkspaceRelativeLocation", this.dockerComposeFilePathWorkspaceRelative);
    }

    public String getName() {
        return LaunchMessages.getString("DockerComposeUpLaunchConfigurationMainTab.name");
    }

    private class LaunchConfigurationChangeListener
    extends SelectionAdapter
    implements ModifyListener {
        private LaunchConfigurationChangeListener() {
        }

        public void modifyText(ModifyEvent e) {
            DockerComposeUpLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            DockerComposeUpLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

