/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class PDFDocument
implements Drawable {
    Device device;
    long pdfContext;
    NSGraphicsContext graphicsContext;
    boolean isGCCreated = false;
    boolean disposed = false;
    boolean pageStarted = false;
    double widthInPoints;
    double heightInPoints;

    public PDFDocument(String filename, double widthInPoints, double heightInPoints) {
        this(null, filename, widthInPoints, heightInPoints);
    }

    public PDFDocument(Device device, String filename, double widthInPoints, double heightInPoints) {
        if (filename == null) {
            SWT.error(4);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.widthInPoints = widthInPoints;
            this.heightInPoints = heightInPoints;
            if (device == null) {
                try {
                    this.device = Display.getDefault();
                }
                catch (Exception e) {
                    this.device = null;
                }
            } else {
                this.device = device;
            }
            NSString path = NSString.stringWith(filename);
            NSURL fileURL = NSURL.fileURLWithPath(path);
            CGRect mediaBox = this.createMediaBox();
            this.pdfContext = OS.CGPDFContextCreateWithURL(fileURL.id, mediaBox, 0L);
            if (this.pdfContext == 0L) {
                SWT.error(2);
            }
            this.graphicsContext = NSGraphicsContext.graphicsContextWithGraphicsPort(this.pdfContext, false);
            if (this.graphicsContext == null) {
                OS.CGContextRelease(this.pdfContext);
                this.pdfContext = 0L;
                SWT.error(2);
            }
            this.graphicsContext.retain();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    private CGRect createMediaBox() {
        CGRect mediaBox = new CGRect();
        mediaBox.origin.x = 0.0;
        mediaBox.origin.y = 0.0;
        mediaBox.size.width = this.widthInPoints;
        mediaBox.size.height = this.heightInPoints;
        return mediaBox;
    }

    private void ensurePageStarted() {
        if (!this.pageStarted) {
            OS.CGPDFContextBeginPage(this.pdfContext, 0L);
            this.pageStarted = true;
        }
    }

    public void newPage() {
        if (this.disposed) {
            SWT.error(24);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.pageStarted) {
                OS.CGPDFContextEndPage(this.pdfContext);
            }
            OS.CGPDFContextBeginPage(this.pdfContext, 0L);
            this.pageStarted = true;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void newPage(double widthInPoints, double heightInPoints) {
        if (this.disposed) {
            SWT.error(24);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        this.widthInPoints = widthInPoints;
        this.heightInPoints = heightInPoints;
        this.newPage();
    }

    public double getWidth() {
        if (this.disposed) {
            SWT.error(24);
        }
        return this.widthInPoints;
    }

    public double getHeight() {
        if (this.disposed) {
            SWT.error(24);
        }
        return this.heightInPoints;
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.disposed) {
            SWT.error(24);
        }
        if (this.isGCCreated) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.ensurePageStarted();
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(this.graphicsContext);
            if (data != null) {
                int mask = 0x6000000;
                if ((data.style & mask) == 0) {
                    data.style |= 0x2000000;
                }
                data.device = this.device;
                data.flippedContext = this.graphicsContext;
                data.restoreContext = true;
                NSSize size = new NSSize();
                size.width = this.widthInPoints;
                size.height = this.heightInPoints;
                data.size = size;
                if (this.device != null) {
                    data.background = this.device.getSystemColor((int)1).handle;
                    data.foreground = this.device.getSystemColor((int)2).handle;
                    data.font = this.device.getSystemFont();
                }
            }
            this.isGCCreated = true;
            long l = this.graphicsContext.id;
            return l;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (data != null && data.restoreContext) {
                NSGraphicsContext.static_restoreGraphicsState();
                data.restoreContext = false;
            }
            if (data != null) {
                this.isGCCreated = false;
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.pdfContext != 0L) {
                if (this.pageStarted) {
                    OS.CGPDFContextEndPage(this.pdfContext);
                }
                OS.CGPDFContextClose(this.pdfContext);
                OS.CGContextRelease(this.pdfContext);
                this.pdfContext = 0L;
            }
            if (this.graphicsContext != null) {
                this.graphicsContext.release();
                this.graphicsContext = null;
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }
}

