/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.corext.template.c.FileTemplateContextType;
import org.eclipse.cdt.internal.corext.util.Messages;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.preferences.CSourcePreviewerUpdater;
import org.eclipse.cdt.internal.ui.preferences.CodeTemplateSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.cdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CodeTemplateBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_GENERATE_COMMENTS = CodeTemplateBlock.getCDTUIKey("org.eclipse.cdt.ui.add_comments");
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_IMPORT = 3;
    private static final int IDX_EXPORT = 4;
    private static final int IDX_EXPORTALL = 5;
    protected static final Object COMMENT_NODE = PreferencesMessages.CodeTemplateBlock_templates_comment_node;
    protected static final Object CODE_NODE = PreferencesMessages.CodeTemplateBlock_templates_code_node;
    protected static final Object FILE_NODE = PreferencesMessages.CodeTemplateBlock_templates_file_node;
    private TreeListDialogField<Object> fCodeTemplateTree;
    private SelectionButtonDialogField fGenerateComments;
    protected ProjectTemplateStore fTemplateStore;
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private TemplateVariableProcessor fTemplateProcessor;
    private ContextTypeRegistry fFileTemplateContextTypes;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_GENERATE_COMMENTS};
    }

    public CodeTemplateBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, CodeTemplateBlock.getAllKeys(), container);
        this.fTemplateStore = new ProjectTemplateStore(project);
        try {
            this.fTemplateStore.load();
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        this.fTemplateProcessor = new TemplateVariableProcessor();
        CodeTemplateAdapter adapter = new CodeTemplateAdapter();
        String[] buttonLabels = new String[]{PreferencesMessages.CodeTemplateBlock_templates_new_button, PreferencesMessages.CodeTemplateBlock_templates_edit_button, PreferencesMessages.CodeTemplateBlock_templates_remove_button, PreferencesMessages.CodeTemplateBlock_templates_import_button, PreferencesMessages.CodeTemplateBlock_templates_export_button, PreferencesMessages.CodeTemplateBlock_templates_exportall_button};
        this.fCodeTemplateTree = new TreeListDialogField<Object>(adapter, buttonLabels, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener(adapter);
        this.fCodeTemplateTree.setLabelText(PreferencesMessages.CodeTemplateBlock_templates_label);
        this.fCodeTemplateTree.setViewerComparator(adapter);
        this.fCodeTemplateTree.enableButton(4, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.enableButton(1, false);
        this.fCodeTemplateTree.enableButton(2, false);
        this.fCodeTemplateTree.addElement(COMMENT_NODE);
        this.fCodeTemplateTree.addElement(CODE_NODE);
        this.fCodeTemplateTree.addElement(FILE_NODE);
        this.fCodeTemplateTree.selectFirstElement();
        this.fGenerateComments = new SelectionButtonDialogField(96);
        this.fGenerateComments.setDialogFieldListener(adapter);
        this.fGenerateComments.setLabelText(PreferencesMessages.CodeTemplateBlock_createcomment_label);
        this.updateControls();
    }

    public void postSetSelection(Object element) {
        this.fCodeTemplateTree.postSetSelection((ISelection)new StructuredSelection(element));
    }

    @Override
    public boolean hasProjectSpecificOptions(IProject project) {
        if (super.hasProjectSpecificOptions(project)) {
            return true;
        }
        if (project != null) {
            return ProjectTemplateStore.hasProjectSpecificTempates(project);
        }
        return false;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fCodeTemplateTree.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fCodeTemplateTree.getTreeControl(null), true);
        this.fPatternViewer = this.createViewer(composite, 2);
        this.fGenerateComments.doFillIntoGrid(composite, 2);
        return composite;
    }

    @Override
    protected void updateControls() {
        this.fGenerateComments.setSelection(this.getBooleanValue(PREF_GENERATE_COMMENTS));
    }

    private SourceViewer createViewer(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText(PreferencesMessages.CodeTemplateBlock_preview);
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        label.setLayoutData((Object)data);
        Document document = new Document();
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        tools.setupCDocumentPartitioner((IDocument)document, "___c_partitioning", null);
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CSourceViewer viewer = new CSourceViewer(parent, null, null, false, 2816, store);
        CodeTemplateSourceViewerConfiguration configuration = new CodeTemplateSourceViewerConfiguration(tools.getColorManager(), store, null, this.fTemplateProcessor);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new CSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        data = new GridData(1296);
        data.horizontalSpan = nColumns;
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    private void reconfigurePatternViewer() {
        if (this.fPatternViewer == null) {
            return;
        }
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CodeTemplateSourceViewerConfiguration configuration = new CodeTemplateSourceViewerConfiguration(tools.getColorManager(), store, null, this.fTemplateProcessor);
        this.fPatternViewer.unconfigure();
        this.fPatternViewer.configure((SourceViewerConfiguration)configuration);
        this.fPatternViewer.invalidateTextPresentation();
    }

    protected TemplatePersistenceData[] getCodeTemplatesOfCategory(boolean isComment) {
        TemplatePersistenceData[] templates;
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templatePersistenceDataArray = templates = this.fTemplateStore.getTemplateData();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            TemplatePersistenceData curr = templatePersistenceDataArray[n2];
            boolean isUserAdded = curr.getId() == null;
            boolean isFileTemplate = FileTemplateContextType.isFileTemplateContextType(curr.getTemplate().getContextTypeId());
            if (!isUserAdded && !isFileTemplate && isComment == curr.getTemplate().getName().endsWith("comment")) {
                res.add(curr);
            }
            ++n2;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    private TemplatePersistenceData[] getTemplatesOfContextType(TemplateContextType contextType) {
        return this.getTemplatesOfContextType(contextType.getId());
    }

    protected TemplatePersistenceData[] getTemplatesOfContextType(String contextTypeId) {
        TemplatePersistenceData[] templates;
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templatePersistenceDataArray = templates = this.fTemplateStore.getTemplateData();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            TemplatePersistenceData curr = templatePersistenceDataArray[n2];
            if (contextTypeId.equals(curr.getTemplate().getContextTypeId())) {
                res.add(curr);
            }
            ++n2;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    protected ContextTypeRegistry getFileTemplateContextRegistry() {
        if (this.fFileTemplateContextTypes == null) {
            this.fFileTemplateContextTypes = new ContextTypeRegistry();
            Iterator contextTypesIter = CUIPlugin.getDefault().getCodeTemplateContextRegistry().contextTypes();
            while (contextTypesIter.hasNext()) {
                TemplateContextType contextType = (TemplateContextType)contextTypesIter.next();
                String contextTypeId = contextType.getId();
                if (!FileTemplateContextType.isFileTemplateContextType(contextTypeId)) continue;
                this.fFileTemplateContextTypes.addContextType(contextType);
            }
        }
        return this.fFileTemplateContextTypes;
    }

    protected TemplateContextType[] getFileTemplateContextTypes() {
        Iterator iter = this.getFileTemplateContextRegistry().contextTypes();
        ArrayList<TemplateContextType> result = new ArrayList<TemplateContextType>();
        while (iter.hasNext()) {
            TemplateContextType contextType = (TemplateContextType)iter.next();
            if (this.getTemplatesOfContextType(contextType).length <= 0) continue;
            result.add(contextType);
        }
        return result.toArray(new TemplateContextType[0]);
    }

    protected static boolean canAdd(List<Object> selected) {
        if (selected.size() == 1) {
            TemplatePersistenceData data;
            Object element = selected.get(0);
            if (element instanceof TemplateContextType || element == FILE_NODE) {
                return true;
            }
            if (element instanceof TemplatePersistenceData && FileTemplateContextType.isFileTemplateContextType((data = (TemplatePersistenceData)element).getTemplate().getContextTypeId())) {
                return true;
            }
        }
        return false;
    }

    protected static boolean canEdit(List<Object> selected) {
        return selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData;
    }

    protected static boolean canRemove(List<Object> selected) {
        if (selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selected.get(0);
            return data.isUserAdded();
        }
        return false;
    }

    protected void updateSourceViewerInput(List<Object> selection) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (selection.size() == 1 && selection.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.get(0);
            Template template = data.getTemplate();
            TemplateContextType type = CUIPlugin.getDefault().getCodeTemplateContextRegistry().getContextType(template.getContextTypeId());
            this.fTemplateProcessor.setContextType(type);
            this.reconfigurePatternViewer();
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int buttonIndex, List<Object> selected) {
        switch (buttonIndex) {
            case 1: {
                this.edit((TemplatePersistenceData)selected.get(0), false);
                break;
            }
            case 0: {
                String contextTypeId;
                Object element = selected.get(0);
                Template orig = null;
                if (element instanceof TemplatePersistenceData) {
                    orig = ((TemplatePersistenceData)element).getTemplate();
                    contextTypeId = orig.getContextTypeId();
                } else if (element instanceof TemplateContextType) {
                    TemplateContextType type = (TemplateContextType)selected.get(0);
                    contextTypeId = type.getId();
                } else {
                    contextTypeId = "org.eclipse.core.runtime.text.contenttype_context";
                }
                Template newTemplate = orig != null ? new Template("", "", contextTypeId, orig.getPattern(), false) : new Template("", "", contextTypeId, "", false);
                TemplatePersistenceData newData = new TemplatePersistenceData(newTemplate, true);
                this.edit(newData, true);
                break;
            }
            case 2: {
                this.remove((TemplatePersistenceData)selected.get(0));
                break;
            }
            case 4: {
                this.export(selected);
                break;
            }
            case 5: {
                this.exportAll();
                break;
            }
            case 3: {
                this.import_();
            }
        }
    }

    private void remove(TemplatePersistenceData data) {
        if (data.isUserAdded()) {
            this.fTemplateStore.delete(data);
            this.fCodeTemplateTree.refresh();
        }
    }

    private void edit(TemplatePersistenceData data, boolean isNew) {
        Template newTemplate = new Template(data.getTemplate());
        boolean isFileTemplate = FileTemplateContextType.isFileTemplateContextType(newTemplate.getContextTypeId());
        Object contextTypeRegistry = isFileTemplate ? this.getFileTemplateContextRegistry() : CUIPlugin.getDefault().getCodeTemplateContextRegistry();
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), newTemplate, !isNew, data.isUserAdded(), isFileTemplate, (ContextTypeRegistry)contextTypeRegistry);
        if (dialog.open() == 0) {
            data.setTemplate(dialog.getTemplate());
            if (isNew) {
                this.fTemplateStore.addTemplateData(data);
            }
            if (isNew || isFileTemplate) {
                this.fCodeTemplateTree.refresh();
            } else {
                this.fCodeTemplateTree.refresh(data);
            }
            this.fCodeTemplateTree.selectElements((ISelection)new StructuredSelection((Object)data));
        }
    }

    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PreferencesMessages.CodeTemplateBlock_import_title);
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_import_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    TemplatePersistenceData[] datas;
                    TemplatePersistenceData[] templatePersistenceDataArray = datas = reader.read((InputStream)input, null);
                    int n = datas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TemplatePersistenceData data = templatePersistenceDataArray[n2];
                        this.updateTemplate(data);
                        ++n2;
                    }
                }
                finally {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.fCodeTemplateTree.refresh();
            this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        String dataId = data.getId();
        TemplatePersistenceData[] datas = this.fTemplateStore.getTemplateData();
        if (dataId != null) {
            TemplatePersistenceData[] templatePersistenceDataArray = datas;
            int n = datas.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData data2 = templatePersistenceDataArray[n2];
                String id = data2.getId();
                if (id != null && id.equals(dataId)) {
                    data2.setTemplate(data.getTemplate());
                    return;
                }
                ++n2;
            }
        } else {
            String dataName = data.getTemplate().getName();
            TemplatePersistenceData[] templatePersistenceDataArray = datas;
            int n = datas.length;
            int n3 = 0;
            while (n3 < n) {
                TemplatePersistenceData data2 = templatePersistenceDataArray[n3];
                if (data2.getId() == null) {
                    String name = data2.getTemplate().getName();
                    String contextTypeId = data2.getTemplate().getContextTypeId();
                    if (name != null && name.equals(dataName) && contextTypeId.equals(data.getTemplate().getContextTypeId())) {
                        data2.setTemplate(data.getTemplate());
                        return;
                    }
                }
                ++n3;
            }
            this.fTemplateStore.addTemplateData(data);
        }
    }

    private void exportAll() {
        this.export(this.fTemplateStore.getTemplateData());
    }

    private void export(List<Object> selected) {
        HashSet<Object> datas = new HashSet<Object>();
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof TemplatePersistenceData) {
                datas.add(curr);
            } else if (curr instanceof TemplateContextType) {
                cat = this.getTemplatesOfContextType((TemplateContextType)curr);
                datas.addAll(Arrays.asList(cat));
            } else if (curr == FILE_NODE) {
                TemplateContextType[] types;
                TemplateContextType[] templateContextTypeArray = types = this.getFileTemplateContextTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplateContextType contextType = templateContextTypeArray[n2];
                    TemplatePersistenceData[] cat = this.getTemplatesOfContextType(contextType);
                    datas.addAll(Arrays.asList(cat));
                    ++n2;
                }
            } else if (curr == COMMENT_NODE || curr == CODE_NODE) {
                cat = this.getCodeTemplatesOfCategory(curr == COMMENT_NODE);
                datas.addAll(Arrays.asList(cat));
            }
            ++i;
        }
        this.export(datas.toArray(new TemplatePersistenceData[datas.size()]));
    }

    private void export(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.format(PreferencesMessages.CodeTemplateBlock_export_title, String.valueOf(templates.length)));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_export_extension});
        dialog.setFileName(PreferencesMessages.CodeTemplateBlock_export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String message = Messages.format(PreferencesMessages.CodeTemplateBlock_export_error_hidden, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String message = Messages.format(PreferencesMessages.CodeTemplateBlock_export_error_canNotWrite, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter writer = new TemplateReaderWriter();
                writer.save(templates, output);
                output.close();
            }
            catch (IOException e) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.openWriteErrorDialog();
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferencesMessages.CodeTemplateBlock_export_exists_title, (String)Messages.format(PreferencesMessages.CodeTemplateBlock_export_exists_message, file.getAbsolutePath()));
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.fTemplateStore.restoreDefaults();
        this.fCodeTemplateTree.refresh();
        this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
    }

    public boolean performOk(boolean enabled) {
        boolean res = super.performOk();
        if (!res) {
            return false;
        }
        if (this.fProject != null) {
            TemplatePersistenceData[] templateData;
            TemplatePersistenceData[] templatePersistenceDataArray = templateData = this.fTemplateStore.getTemplateData();
            int n = templateData.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData element = templatePersistenceDataArray[n2];
                this.fTemplateStore.setProjectSpecific(element.getId(), enabled);
                ++n2;
            }
        }
        try {
            this.fTemplateStore.save();
        }
        catch (IOException e) {
            CUIPlugin.log(e);
            this.openWriteErrorDialog();
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplateStore.revertChanges();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(Exception e) {
        String title = PreferencesMessages.CodeTemplateBlock_error_read_title;
        String message = e.getLocalizedMessage();
        message = message != null ? Messages.format(PreferencesMessages.CodeTemplateBlock_error_parse_message, message) : PreferencesMessages.CodeTemplateBlock_error_read_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog() {
        String title = PreferencesMessages.CodeTemplateBlock_error_write_title;
        String message = PreferencesMessages.CodeTemplateBlock_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    private class CodeTemplateAdapter
    extends ViewerComparator
    implements ITreeListAdapter<Object>,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        private CodeTemplateAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField<Object> field, int index) {
            CodeTemplateBlock.this.doButtonPressed(index, field.getSelectedElements());
        }

        @Override
        public void selectionChanged(TreeListDialogField<Object> field) {
            List<Object> selected = field.getSelectedElements();
            field.enableButton(0, CodeTemplateBlock.canAdd(selected));
            field.enableButton(1, CodeTemplateBlock.canEdit(selected));
            field.enableButton(2, CodeTemplateBlock.canRemove(selected));
            field.enableButton(4, !selected.isEmpty());
            CodeTemplateBlock.this.updateSourceViewerInput(selected);
        }

        @Override
        public void doubleClicked(TreeListDialogField<Object> field) {
            List<Object> selected = field.getSelectedElements();
            if (CodeTemplateBlock.canEdit(selected)) {
                CodeTemplateBlock.this.doButtonPressed(1, selected);
            }
        }

        @Override
        public Object[] getChildren(TreeListDialogField<Object> field, Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return CodeTemplateBlock.this.getCodeTemplatesOfCategory(element == COMMENT_NODE);
            }
            if (element == FILE_NODE) {
                return CodeTemplateBlock.this.getFileTemplateContextTypes();
            }
            if (element instanceof TemplateContextType) {
                return CodeTemplateBlock.this.getTemplatesOfContextType(((TemplateContextType)element).getId());
            }
            return this.NO_CHILDREN;
        }

        @Override
        public Object getParent(TreeListDialogField<Object> field, Object element) {
            if (element instanceof TemplatePersistenceData) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                if (data.getTemplate().getName().endsWith("comment")) {
                    return COMMENT_NODE;
                }
                if (FileTemplateContextType.isFileTemplateContextType(data.getTemplate().getContextTypeId())) {
                    return CodeTemplateBlock.this.getFileTemplateContextRegistry().getContextType(data.getTemplate().getContextTypeId());
                }
                return CODE_NODE;
            }
            if (element instanceof TemplateContextType) {
                return FILE_NODE;
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<Object> field, Object element) {
            return element == COMMENT_NODE || element == CODE_NODE || element == FILE_NODE || element instanceof TemplateContextType;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == CodeTemplateBlock.this.fGenerateComments) {
                CodeTemplateBlock.this.setValue(PREF_GENERATE_COMMENTS, CodeTemplateBlock.this.fGenerateComments.isSelected());
            }
        }

        @Override
        public void keyPressed(TreeListDialogField<Object> field, KeyEvent event) {
        }

        public int category(Object element) {
            if (element == COMMENT_NODE) {
                return 1;
            }
            if (element == CODE_NODE) {
                return 2;
            }
            if (element == FILE_NODE) {
                return 3;
            }
            if (element instanceof TemplateContextType) {
                TemplateContextType type = (TemplateContextType)element;
                String id = type.getId();
                if ("org.eclipse.cdt.core.cxxSource.contenttype_context".equals(id)) {
                    return 1;
                }
                if ("org.eclipse.cdt.core.cxxHeader.contenttype_context".equals(id)) {
                    return 2;
                }
                if ("org.eclipse.cdt.core.cSource.contenttype_context".equals(id)) {
                    return 10;
                }
                if ("org.eclipse.cdt.core.cHeader.contenttype_context".equals(id)) {
                    return 11;
                }
                if ("org.eclipse.cdt.core.asmSource.contenttype_context".equals(id)) {
                    return 100;
                }
                if (id.startsWith("org.eclipse.cdt.")) {
                    return 101;
                }
                return 1000;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if ("org.eclipse.cdt.core.asmSource.contenttype_context".equals(id)) {
                return 105;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.namespace_begin".equals(id)) {
                return 106;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.namespace_end".equals(id)) {
                return 107;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.class_body".equals(id)) {
                return 108;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.methodbody".equals(id)) {
                return 109;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.constructorbody".equals(id)) {
                return 110;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.destructorbody".equals(id)) {
                return 111;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.filecomment".equals(id)) {
                return 1;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.typecomment".equals(id)) {
                return 2;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.fieldcomment".equals(id)) {
                return 3;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.methodcomment".equals(id)) {
                return 4;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.constructorcomment".equals(id)) {
                return 5;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.destructorcomment".equals(id)) {
                return 6;
            }
            return 1000;
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        private CodeTemplateLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE || element == FILE_NODE) {
                return (String)element;
            }
            if (element instanceof TemplateContextType) {
                return ((TemplateContextType)element).getName();
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if (FileTemplateContextType.isFileTemplateContextType(data.getTemplate().getContextTypeId())) {
                return data.getTemplate().getName();
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.namespace_begin".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_namespace_begin_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.namespace_end".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_namespace_end_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.class_body".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_class_body_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.constructorbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_constructorstub_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.destructorbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_destructorstub_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.methodbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_methodstub_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.filecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_filecomment_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.typecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_typecomment_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.fieldcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_fieldcomment_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.methodcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_methodcomment_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.constructorcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_constructorcomment_label;
            }
            if ("org.eclipse.cdt.ui.text.codetemplates.destructorcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_destructorcomment_label;
            }
            return data.getTemplate().getName();
        }
    }
}

