/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.TmfVertexLegacyWrapper;

public class TmfEdgeLegacyWrapper
implements ITmfEdge {
    private TmfEdge fLegacyEdge;
    private TmfVertexLegacyWrapper fFrom;
    private TmfVertexLegacyWrapper fTo;

    public static TmfEdge.EdgeType newTypeToOldType(OSEdgeContextState contextState) {
        return contextState.getOldEdgeType();
    }

    public static OSEdgeContextState oldTypeToNewType(TmfEdge.EdgeType type) {
        return new OSEdgeContextState(type);
    }

    public TmfEdgeLegacyWrapper(TmfEdge edge, TmfVertexLegacyWrapper from, TmfVertexLegacyWrapper to) {
        this.fLegacyEdge = edge;
        this.fFrom = from;
        this.fTo = to;
    }

    @Override
    public ITmfVertex getVertexFrom() {
        return this.fFrom;
    }

    @Override
    public ITmfVertex getVertexTo() {
        return this.fTo;
    }

    @Override
    public OSEdgeContextState getEdgeContextState() {
        return TmfEdgeLegacyWrapper.oldTypeToNewType(this.fLegacyEdge.getType());
    }

    @Override
    public @Nullable String getLinkQualifier() {
        return this.fLegacyEdge.getLinkQualifier();
    }

    @Override
    public long getDuration() {
        return this.fLegacyEdge.getDuration();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TmfEdgeLegacyWrapper)) {
            return false;
        }
        TmfEdgeLegacyWrapper other = (TmfEdgeLegacyWrapper)obj;
        return Objects.equals(this.fLegacyEdge, other.fLegacyEdge) && Objects.equals(this.fFrom, other.fFrom) && Objects.equals(this.fTo, other.fTo);
    }

    public int hashCode() {
        return Objects.hash(this.fLegacyEdge, this.fTo, this.fFrom);
    }

    public String toString() {
        return "[Legacy edge: " + String.valueOf(this.fLegacyEdge) + "]";
    }
}

