/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class BeginWhileRule
extends Rule {
    private final RegExpSource begin;
    public final List<@Nullable CaptureRule> beginCaptures;
    public final List<@Nullable CaptureRule> whileCaptures;
    private final RegExpSource _while;
    public final boolean whileHasBackReferences;
    final boolean hasMissingPatterns;
    final RuleId[] patterns;
    private @Nullable RegExpSourceList cachedCompiledPatterns;
    private @Nullable RegExpSourceList cachedCompiledWhilePatterns;

    BeginWhileRule(RuleId id, @Nullable String name, @Nullable String contentName, String begin, List<@Nullable CaptureRule> beginCaptures, String _while, List<@Nullable CaptureRule> whileCaptures, CompilePatternsResult patterns, @Nullable String grammarScope) {
        super(id, name, contentName, grammarScope);
        this.begin = new RegExpSource(begin, this.id);
        this.beginCaptures = beginCaptures;
        this.whileCaptures = whileCaptures;
        this._while = new RegExpSource(_while, RuleId.WHILE_RULE);
        this.whileHasBackReferences = this._while.hasBackReferences;
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
    }

    public String getWhileWithResolvedBackReferences(CharSequence lineText, OnigCaptureIndex[] captureIndices) {
        return this._while.resolveBackReferences(lineText, captureIndices);
    }

    @Override
    public void collectPatterns(IRuleRegistry grammar, RegExpSourceList out) {
        out.add(this.begin);
    }

    @Override
    public CompiledRule compile(IRuleRegistry grammar, @Nullable String endRegexSource) {
        return this.getCachedCompiledPatterns(grammar).compile();
    }

    @Override
    public CompiledRule compileAG(IRuleRegistry grammar, @Nullable String endRegexSource, boolean allowA, boolean allowG) {
        return this.getCachedCompiledPatterns(grammar).compileAG(allowA, allowG);
    }

    private RegExpSourceList getCachedCompiledPatterns(IRuleRegistry grammar) {
        RegExpSourceList cachedCompiledPatterns = this.cachedCompiledPatterns;
        if (cachedCompiledPatterns == null) {
            this.cachedCompiledPatterns = cachedCompiledPatterns = new RegExpSourceList();
            RuleId[] ruleIdArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                RuleId pattern = ruleIdArray[n2];
                Rule rule = grammar.getRule(pattern);
                rule.collectPatterns(grammar, cachedCompiledPatterns);
                ++n2;
            }
        }
        return cachedCompiledPatterns;
    }

    public CompiledRule compileWhile(@Nullable String endRegexSource) {
        return this.getCachedCompiledWhilePatterns(endRegexSource).compile();
    }

    public CompiledRule compileWhileAG(@Nullable String endRegexSource, boolean allowA, boolean allowG) {
        return this.getCachedCompiledWhilePatterns(endRegexSource).compileAG(allowA, allowG);
    }

    private RegExpSourceList getCachedCompiledWhilePatterns(@Nullable String endRegexSource) {
        RegExpSourceList cachedCompiledWhilePatterns = this.cachedCompiledWhilePatterns;
        if (cachedCompiledWhilePatterns == null) {
            cachedCompiledWhilePatterns = new RegExpSourceList();
            cachedCompiledWhilePatterns.add(this.whileHasBackReferences ? this._while.clone() : this._while);
            this.cachedCompiledWhilePatterns = cachedCompiledWhilePatterns;
        }
        if (this.whileHasBackReferences) {
            cachedCompiledWhilePatterns.setSource(0, NullSafetyHelper.defaultIfNull(endRegexSource, "\uffff"));
        }
        return cachedCompiledWhilePatterns;
    }
}

