/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.Test;
import org.eclipse.buildship.core.internal.launch.BaseRunConfigurationAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class GradleTestRunConfigurationAttributes
extends BaseRunConfigurationAttributes {
    private static final String TEST_ClASSES = "tests";
    private final List<String> testNames;

    public GradleTestRunConfigurationAttributes(String workingDirExpression, String gradleDistribution, String gradleUserHomeExpression, String javaHomeExpression, List<String> jvmArgumentExpressions, List<String> argumentExpressions, boolean showExecutionView, boolean showConsoleView, boolean overrideWorkspaceSettings, boolean isOffline, boolean isBuildScansEnabled, List<String> testNames) {
        super(workingDirExpression, gradleDistribution, gradleUserHomeExpression, javaHomeExpression, jvmArgumentExpressions, argumentExpressions, showExecutionView, showConsoleView, overrideWorkspaceSettings, isOffline, isBuildScansEnabled);
        this.testNames = testNames;
    }

    public List<String> getTestNames() {
        return this.testNames;
    }

    public List<Test> getTests() {
        return Test.fromString(this.testNames);
    }

    public boolean hasSameUniqueAttributes(ILaunchConfiguration launchConfiguration) {
        try {
            return this.workingDirExpression.equals(launchConfiguration.getAttribute("working_dir", "")) && this.testNames.equals(launchConfiguration.getAttribute(TEST_ClASSES, Collections.emptyList()));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read Gradle launch configuration %s.", launchConfiguration), e);
        }
    }

    @Override
    public void apply(ILaunchConfigurationWorkingCopy launchConfiguration) {
        super.apply(launchConfiguration);
        GradleTestRunConfigurationAttributes.applyTestNames(this.testNames, launchConfiguration);
    }

    public static void applyTestNames(List<String> testNames, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(TEST_ClASSES, testNames);
    }

    public static GradleTestRunConfigurationAttributes from(ILaunchConfiguration launchConfiguration) {
        Preconditions.checkNotNull((Object)launchConfiguration);
        String workingDirExpression = GradleTestRunConfigurationAttributes.getStringAttribute("working_dir", "", launchConfiguration);
        String gradleDistribution = GradleTestRunConfigurationAttributes.getStringAttribute("gradle_distribution", GradleDistribution.fromBuild().toString(), launchConfiguration);
        String gradleUserHomeExpression = GradleTestRunConfigurationAttributes.getStringAttribute("gradle_user_home", null, launchConfiguration);
        String javaHomeExpression = GradleTestRunConfigurationAttributes.getStringAttribute("java_home", null, launchConfiguration);
        List<String> jvmArgumentExpressions = GradleTestRunConfigurationAttributes.getListAttribute("jvm_arguments", launchConfiguration);
        List<String> argumentExpressions = GradleTestRunConfigurationAttributes.getListAttribute("arguments", launchConfiguration);
        boolean showExecutionView = GradleTestRunConfigurationAttributes.getBooleanAttribute("show_execution_view", true, launchConfiguration);
        boolean showConsoleView = GradleTestRunConfigurationAttributes.getBooleanAttribute("show_console_view", true, launchConfiguration);
        boolean overrideWorkspaceSettings = GradleTestRunConfigurationAttributes.getBooleanAttribute("override_workspace_settings", false, launchConfiguration);
        boolean isOffline = GradleTestRunConfigurationAttributes.getBooleanAttribute("offline_mode", false, launchConfiguration);
        boolean isBuildScansEnabled = GradleTestRunConfigurationAttributes.getBooleanAttribute("build_scans_enabled", false, launchConfiguration);
        List<String> testNames = GradleTestRunConfigurationAttributes.getListAttribute(TEST_ClASSES, launchConfiguration);
        return new GradleTestRunConfigurationAttributes(workingDirExpression, gradleDistribution, gradleUserHomeExpression, javaHomeExpression, jvmArgumentExpressions, argumentExpressions, showExecutionView, showConsoleView, overrideWorkspaceSettings, isOffline, isBuildScansEnabled, testNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GradleTestRunConfigurationAttributes) {
            GradleTestRunConfigurationAttributes other = (GradleTestRunConfigurationAttributes)obj;
            return super.equals(obj) && Objects.equal(this.testNames, other.testNames);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.testNames});
    }
}

