/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.archive.compound.NameEntry;

class NameTable
implements ArchiveConstants {
    protected ArrayList<NameEntry> slots;
    protected AllocEntry index;
    protected ArchiveFileV2 af;
    protected final int BLOCK_SIZE;

    private NameTable(ArchiveFileV2 af) throws IOException {
        this.af = af;
        this.BLOCK_SIZE = af.BLOCK_SIZE;
        this.slots = new ArrayList();
        this.index = af.allocTbl.loadEntry(2);
    }

    static NameTable loadTable(ArchiveFileV2 af) throws IOException {
        NameTable table = new NameTable(af);
        table.refresh();
        return table;
    }

    static NameTable createTable(ArchiveFileV2 af) throws IOException {
        NameTable table = new NameTable(af);
        return table;
    }

    synchronized void refresh() throws IOException {
        this.index.refresh(this.af.allocTbl);
        int maxSlots = this.index.getTotalBlocks() * this.BLOCK_SIZE / 128;
        int lastSlot = this.slots.size();
        while (lastSlot < maxSlots) {
            NameEntry entry = new NameEntry(lastSlot);
            entry.read(this);
            int usedSlots = entry.getUsedSlots();
            if (usedSlots == -1) break;
            if (usedSlots == 0) {
                usedSlots = 1;
            }
            lastSlot += usedSlots;
            this.slots.add(entry);
            int i = 1;
            while (i < usedSlots) {
                this.slots.add(null);
                ++i;
            }
        }
        assert (this.slots.size() == lastSlot);
    }

    synchronized void flush() throws IOException {
        this.ensureSlots(this.slots.size() + 1);
        for (NameEntry entry : this.slots) {
            if (entry == null) continue;
            entry.write(this);
        }
        NameEntry lastEntry = new NameEntry(this.slots.size());
        lastEntry.setUsedSlots(-1);
        lastEntry.write(this);
    }

    synchronized void removeEntry(NameEntry entry) throws IOException {
        int slotId = entry.getSlotID();
        int usedSlots = entry.getUsedSlots();
        int i = slotId;
        while (i < usedSlots) {
            this.slots.set(i, new NameEntry(i));
            ++i;
        }
    }

    synchronized NameEntry createEntry(String name) throws IOException {
        int lastSlot = this.slots.size();
        NameEntry entry = new NameEntry(lastSlot, name);
        int usedSlots = entry.getUsedSlots();
        this.slots.add(entry);
        int i = 1;
        while (i < usedSlots) {
            this.slots.add(null);
            ++i;
        }
        return entry;
    }

    synchronized Collection<NameEntry> listEntries() {
        ArrayList<NameEntry> entries = new ArrayList<NameEntry>();
        for (NameEntry entry : this.slots) {
            if (entry == null || entry.getUsedSlots() == 0) continue;
            entries.add(entry);
        }
        return entries;
    }

    private void ensureSlots(int slotSize) throws IOException {
        long offset = (long)(slotSize + 1) * 128L;
        int blockCount = (int)((offset + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE);
        int totalBlock = this.index.getTotalBlocks();
        while (blockCount > totalBlock) {
            int freeBlock = this.af.allocTbl.getFreeBlock();
            this.index.appendBlock(freeBlock);
            ++totalBlock;
        }
    }

    void readSlot(int slotId, byte[] b, int off) throws IOException {
        long offset = (long)slotId * 128L;
        int blkId = (int)(offset / (long)this.BLOCK_SIZE);
        int blkOff = (int)(offset % (long)this.BLOCK_SIZE);
        int phyBlk = this.index.getBlock(blkId);
        this.af.read(phyBlk, blkOff, b, off, 128);
    }

    void writeSlot(int slotId, byte[] b, int off) throws IOException {
        long offset = (long)slotId * 128L;
        int blkId = (int)(offset / (long)this.BLOCK_SIZE);
        int blkOff = (int)(offset % (long)this.BLOCK_SIZE);
        int phyBlk = this.index.getBlock(blkId);
        int size = b.length - off;
        if (size > 128) {
            size = 128;
        }
        this.af.write(phyBlk, blkOff, b, off, size);
    }

    void debug_dump() {
        System.out.println("NAME TABLE:");
        int i = 0;
        while (i < this.index.getTotalBlocks()) {
            System.out.print(String.valueOf(this.index.getBlock(i)) + ",");
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < this.slots.size()) {
            NameEntry entry = this.slots.get(i);
            if (entry != null) {
                System.out.print(String.valueOf(entry.getSlotID()) + ",");
                System.out.print(String.valueOf(entry.getUsedSlots()) + ",");
                if (entry.getUsedSlots() > 0) {
                    System.out.print(String.valueOf(entry.getLength()) + ",");
                    System.out.print(String.valueOf(entry.getName()) + ",");
                    System.out.print(entry.getBlock());
                }
                System.out.println();
            }
            ++i;
        }
    }
}

