/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.AlgorithmHelper;
import org.eclipse.zest.layouts.algorithms.ContinuousLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.LayoutListener;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class SpringLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    public static final int DEFAULT_SPRING_ITERATIONS = 1000;
    public static final long MAX_SPRING_TIME = 10000L;
    public static final boolean DEFAULT_SPRING_RANDOM = true;
    public static final double DEFAULT_SPRING_MOVE = 1.0;
    public static final double DEFAULT_SPRING_STRAIN = 1.0;
    public static final double DEFAULT_SPRING_LENGTH = 3.0;
    public static final double DEFAULT_SPRING_GRAVITATION = 2.0;
    protected static final double MIN_DISTANCE = 1.0;
    protected static final double EPSILON = 0.001;
    private int sprIterations = 1000;
    private long maxTimeMS = 10000L;
    private boolean sprRandom = true;
    private double sprMove = 1.0;
    private double sprStrain = 1.0;
    private double sprLength = 3.0;
    private double sprGravitation = 2.0;
    private boolean resize = false;
    private int iteration;
    private double[][] srcDestToSumOfWeights;
    private EntityLayout[] entities;
    private double[] forcesX;
    private double[] forcesY;
    private double[] locationsX;
    private double[] locationsY;
    private double[] sizeW;
    private double[] sizeH;
    private DisplayIndependentRectangle bounds;
    private double boundsScaleX = 0.2;
    private double boundsScaleY = 0.2;
    public boolean fitWithinBounds = true;
    private long startTime = 0L;

    @Deprecated
    public SpringLayoutAlgorithm(int style) {
        this();
        this.setResizing(style != 1);
    }

    public SpringLayoutAlgorithm() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void applyLayout(boolean clean) {
        this.initLayout();
        if (clean) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.computeOneIteration();
lbl5:
            // 2 sources

            ** while (this.performAnotherNonContinuousIteration())
        }
lbl6:
        // 1 sources

        this.saveLocations();
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(this.entities);
        }
        if (this.fitWithinBounds) {
            bounds2 = new DisplayIndependentRectangle(this.bounds);
            insets = 4;
            bounds2.x += (double)insets;
            bounds2.y += (double)insets;
            bounds2.width -= (double)(2 * insets);
            bounds2.height -= (double)(2 * insets);
            AlgorithmHelper.fitWithinBounds(this.entities, bounds2, this.resize);
        }
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        super.setLayoutContext(context);
        this.context.addLayoutListener(new SpringLayoutListener());
        this.initLayout();
    }

    public void performNIteration(int n) {
        if (this.iteration == 0) {
            this.entities = this.context.getEntities();
            this.loadLocations();
            this.initLayout();
        }
        this.bounds = this.context.getBounds();
        int i = 0;
        while (i < n) {
            this.computeOneIteration();
            this.saveLocations();
            ++i;
        }
        this.context.flushChanges(false);
    }

    public void performOneIteration() {
        if (this.iteration == 0) {
            this.entities = this.context.getEntities();
            this.loadLocations();
            this.initLayout();
        }
        this.bounds = this.context.getBounds();
        this.computeOneIteration();
        this.saveLocations();
        this.context.flushChanges(false);
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }

    public void setSpringMove(double move) {
        this.sprMove = move;
    }

    public double getSpringMove() {
        return this.sprMove;
    }

    public void setSpringStrain(double strain) {
        this.sprStrain = strain;
    }

    public double getSpringStrain() {
        return this.sprStrain;
    }

    public void setSpringLength(double length) {
        this.sprLength = length;
    }

    public long getSpringTimeout() {
        return this.maxTimeMS;
    }

    public void setSpringTimeout(long timeout) {
        this.maxTimeMS = timeout;
    }

    public double getSpringLength() {
        return this.sprLength;
    }

    public void setSpringGravitation(double gravitation) {
        this.sprGravitation = gravitation;
    }

    public double getSpringGravitation() {
        return this.sprGravitation;
    }

    public void setIterations(int iterations) {
        this.sprIterations = iterations;
    }

    public int getIterations() {
        return this.sprIterations;
    }

    public void setRandom(boolean random) {
        this.sprRandom = random;
    }

    public boolean getRandom() {
        return this.sprRandom;
    }

    private void initLayout() {
        ConnectionLayout[] connections;
        this.entities = this.context.getEntities();
        this.bounds = this.context.getBounds();
        this.loadLocations();
        this.srcDestToSumOfWeights = new double[this.entities.length][this.entities.length];
        HashMap<EntityLayout, Integer> entityToPosition = new HashMap<EntityLayout, Integer>();
        int i = 0;
        while (i < this.entities.length) {
            entityToPosition.put(this.entities[i], i);
            ++i;
        }
        ConnectionLayout[] connectionLayoutArray = connections = this.context.getConnections();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionLayout connection = connectionLayoutArray[n2];
            Integer source = (Integer)entityToPosition.get(SpringLayoutAlgorithm.getEntity(connection.getSource()));
            Integer target = (Integer)entityToPosition.get(SpringLayoutAlgorithm.getEntity(connection.getTarget()));
            if (source != null && target != null) {
                double weight = connection.getWeight();
                weight = weight <= 0.0 ? 0.1 : weight;
                double[] dArray = this.srcDestToSumOfWeights[source];
                int n3 = target;
                dArray[n3] = dArray[n3] + weight;
                double[] dArray2 = this.srcDestToSumOfWeights[target];
                int n4 = source;
                dArray2[n4] = dArray2[n4] + weight;
            }
            ++n2;
        }
        if (this.sprRandom) {
            this.placeRandomly();
        }
        this.iteration = 1;
        this.startTime = System.currentTimeMillis();
    }

    private static EntityLayout getEntity(NodeLayout node) {
        if (!node.isPruned()) {
            return node;
        }
        SubgraphLayout subgraph = node.getSubgraph();
        if (subgraph.isGraphEntity()) {
            return subgraph;
        }
        return null;
    }

    private void loadLocations() {
        if (this.locationsX == null || this.locationsX.length != this.entities.length) {
            int length = this.entities.length;
            this.locationsX = new double[length];
            this.locationsY = new double[length];
            this.sizeW = new double[length];
            this.sizeH = new double[length];
            this.forcesX = new double[length];
            this.forcesY = new double[length];
        }
        int i = 0;
        while (i < this.entities.length) {
            DisplayIndependentPoint location = this.entities[i].getLocation();
            this.locationsX[i] = location.x;
            this.locationsY[i] = location.y;
            DisplayIndependentDimension size = this.entities[i].getSize();
            this.sizeW[i] = size.width;
            this.sizeH[i] = size.height;
            ++i;
        }
    }

    private void saveLocations() {
        if (this.entities == null) {
            return;
        }
        int i = 0;
        while (i < this.entities.length) {
            this.entities[i].setLocation(this.locationsX[i], this.locationsY[i]);
            ++i;
        }
    }

    private void setSprIterationsBasedOnTime() {
        if (this.maxTimeMS <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        double fractionComplete = (double)(currentTime - this.startTime) / (double)this.maxTimeMS;
        int currentIteration = (int)(fractionComplete * (double)this.sprIterations);
        if (currentIteration > this.iteration) {
            this.iteration = currentIteration;
        }
    }

    protected boolean performAnotherNonContinuousIteration() {
        this.setSprIterationsBasedOnTime();
        return this.iteration <= this.sprIterations;
    }

    protected int getCurrentLayoutStep() {
        return this.iteration;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return this.sprIterations;
    }

    protected void computeOneIteration() {
        this.computeForces();
        this.computePositions();
        DisplayIndependentRectangle currentBounds = this.getLayoutBounds();
        this.improveBoundScaleX(currentBounds);
        this.improveBoundScaleY(currentBounds);
        this.moveToCenter(currentBounds);
        ++this.iteration;
    }

    public void placeRandomly() {
        if (this.locationsX.length == 0) {
            return;
        }
        if (this.locationsX.length == 1) {
            this.locationsX[0] = this.bounds.x + 0.5 * this.bounds.width;
            this.locationsY[0] = this.bounds.y + 0.5 * this.bounds.height;
        } else {
            this.locationsX[0] = this.bounds.x;
            this.locationsY[0] = this.bounds.y;
            this.locationsX[1] = this.bounds.x + this.bounds.width;
            this.locationsY[1] = this.bounds.y + this.bounds.height;
            int i = 2;
            while (i < this.locationsX.length) {
                this.locationsX[i] = this.bounds.x + Math.random() * this.bounds.width;
                this.locationsY[i] = this.bounds.y + Math.random() * this.bounds.height;
                ++i;
            }
        }
    }

    protected void computeForces() {
        int i;
        double[][] forcesX = new double[2][this.forcesX.length];
        double[][] forcesY = new double[2][this.forcesX.length];
        double[] locationsX = new double[this.forcesX.length];
        double[] locationsY = new double[this.forcesX.length];
        int j = 0;
        while (j < 2) {
            i = 0;
            while (i < this.forcesX.length) {
                forcesX[j][i] = 0.0;
                forcesY[j][i] = 0.0;
                locationsX[i] = this.locationsX[i];
                locationsY[i] = this.locationsY[i];
                ++i;
            }
            ++j;
        }
        int k = 0;
        while (k < 2) {
            i = 0;
            while (i < this.locationsX.length) {
                int j2 = i + 1;
                while (j2 < locationsX.length) {
                    double dx = (locationsX[i] - locationsX[j2]) / this.bounds.width / this.boundsScaleX;
                    double dy = (locationsY[i] - locationsY[j2]) / this.bounds.height / this.boundsScaleY;
                    double distance_sq = dx * dx + dy * dy;
                    distance_sq = Math.max(1.0, distance_sq);
                    double distance = Math.sqrt(distance_sq);
                    double sumOfWeights = this.srcDestToSumOfWeights[i][j2];
                    double f = sumOfWeights > 0.0 ? -this.sprStrain * Math.log(distance / this.sprLength) * sumOfWeights : this.sprGravitation / distance_sq;
                    double dfx = f * dx / distance;
                    double dfy = f * dy / distance;
                    double[] dArray = forcesX[k];
                    int n = i;
                    dArray[n] = dArray[n] + dfx;
                    double[] dArray2 = forcesY[k];
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + dfy;
                    double[] dArray3 = forcesX[k];
                    int n3 = j2;
                    dArray3[n3] = dArray3[n3] - dfx;
                    double[] dArray4 = forcesY[k];
                    int n4 = j2++;
                    dArray4[n4] = dArray4[n4] - dfy;
                }
                ++i;
            }
            i = 0;
            while (i < this.entities.length) {
                if (this.entities[i].isMovable()) {
                    double maxMovement;
                    double deltaX = this.sprMove * forcesX[k][i];
                    double deltaY = this.sprMove * forcesY[k][i];
                    double dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                    if (dist > (maxMovement = 0.2 * this.sprMove)) {
                        deltaX *= maxMovement / dist;
                        deltaY *= maxMovement / dist;
                    }
                    int n = i;
                    locationsX[n] = locationsX[n] + deltaX * this.bounds.width * this.boundsScaleX;
                    int n5 = i;
                    locationsY[n5] = locationsY[n5] + deltaY * this.bounds.height * this.boundsScaleY;
                }
                ++i;
            }
            ++k;
        }
        int i2 = 0;
        while (i2 < this.entities.length) {
            this.forcesX[i2] = forcesX[0][i2] * forcesX[1][i2] < 0.0 ? 0.0 : forcesX[1][i2];
            this.forcesY[i2] = forcesY[0][i2] * forcesY[1][i2] < 0.0 ? 0.0 : forcesY[1][i2];
            ++i2;
        }
    }

    protected void computePositions() {
        int i = 0;
        while (i < this.entities.length) {
            if (this.entities[i].isMovable()) {
                double maxMovement;
                double deltaX = this.sprMove * this.forcesX[i];
                double deltaY = this.sprMove * this.forcesY[i];
                double dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                if (dist > (maxMovement = 0.2 * this.sprMove)) {
                    deltaX *= maxMovement / dist;
                    deltaY *= maxMovement / dist;
                }
                int n = i;
                this.locationsX[n] = this.locationsX[n] + deltaX * this.bounds.width * this.boundsScaleX;
                int n2 = i;
                this.locationsY[n2] = this.locationsY[n2] + deltaY * this.bounds.height * this.boundsScaleY;
            }
            ++i;
        }
    }

    private DisplayIndependentRectangle getLayoutBounds() {
        double minY = Double.POSITIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.locationsX.length) {
            maxX = Math.max(maxX, this.locationsX[i] + this.sizeW[i] / 2.0);
            minX = Math.min(minX, this.locationsX[i] - this.sizeW[i] / 2.0);
            maxY = Math.max(maxY, this.locationsY[i] + this.sizeH[i] / 2.0);
            minY = Math.min(minY, this.locationsY[i] - this.sizeH[i] / 2.0);
            ++i;
        }
        return new DisplayIndependentRectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private void improveBoundScaleX(DisplayIndependentRectangle currentBounds) {
        double boundaryProportionX = currentBounds.width / this.bounds.width;
        if (boundaryProportionX < 0.9) {
            this.boundsScaleX *= 1.01;
        } else if (boundaryProportionX > 1.0) {
            if (this.boundsScaleX < 0.01) {
                return;
            }
            this.boundsScaleX /= 1.01;
        }
    }

    private void improveBoundScaleY(DisplayIndependentRectangle currentBounds) {
        double boundaryProportionY = currentBounds.height / this.bounds.height;
        if (boundaryProportionY < 0.9) {
            this.boundsScaleY *= 1.01;
        } else if (boundaryProportionY > 1.0) {
            if (this.boundsScaleY < 0.01) {
                return;
            }
            this.boundsScaleY /= 1.01;
        }
    }

    private void moveToCenter(DisplayIndependentRectangle currentBounds) {
        double moveX = currentBounds.x + currentBounds.width / 2.0 - (this.bounds.x + this.bounds.width / 2.0);
        double moveY = currentBounds.y + currentBounds.height / 2.0 - (this.bounds.y + this.bounds.height / 2.0);
        int i = 0;
        while (i < this.locationsX.length) {
            int n = i;
            this.locationsX[n] = this.locationsX[n] - moveX;
            int n2 = i++;
            this.locationsY[n2] = this.locationsY[n2] - moveY;
        }
    }

    class SpringLayoutListener
    implements LayoutListener {
        SpringLayoutListener() {
        }

        @Override
        public boolean nodeMoved(LayoutContext context, NodeLayout node) {
            int i = 0;
            while (i < SpringLayoutAlgorithm.this.entities.length) {
                if (SpringLayoutAlgorithm.this.entities[i] == node) {
                    SpringLayoutAlgorithm.this.locationsX[i] = SpringLayoutAlgorithm.this.entities[i].getLocation().x;
                    SpringLayoutAlgorithm.this.locationsY[i] = SpringLayoutAlgorithm.this.entities[i].getLocation().y;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean nodeResized(LayoutContext context, NodeLayout node) {
            return false;
        }

        @Override
        public boolean subgraphMoved(LayoutContext context, SubgraphLayout subgraph) {
            return false;
        }

        @Override
        public boolean subgraphResized(LayoutContext context, SubgraphLayout subgraph) {
            return false;
        }
    }

    @Deprecated(since="2.0", forRemoval=true)
    public static class Zest1
    extends ContinuousLayoutAlgorithm {
        private static final boolean DEFAULT_ANCHOR = false;
        @Deprecated
        public static final int DEFAULT_SPRING_ITERATIONS = 1000;
        @Deprecated
        public static final long MAX_SPRING_TIME = 10000L;
        @Deprecated
        public static final boolean DEFAULT_SPRING_RANDOM = true;
        @Deprecated
        public static final boolean DEFAULT_SPRING_IGNORE_UNCON = true;
        @Deprecated
        public static final boolean DEFAULT_SPRING_SEPARATE_COMPONENTS = true;
        @Deprecated
        public static final double DEFAULT_SPRING_MOVE = 1.0;
        @Deprecated
        public static final double DEFAULT_SPRING_STRAIN = 1.0;
        @Deprecated
        public static final double DEFAULT_SPRING_LENGTH = 1.0;
        @Deprecated
        public static final double DEFAULT_SPRING_GRAVITATION = 1.0;
        private static int sprIterations = 1000;
        private static long maxTimeMS = 10000L;
        private static boolean sprRandom = true;
        @Deprecated
        protected static final double MIN_DISTANCE = 0.001;
        @Deprecated
        protected static final double EPSILON = 0.001;
        private static double sprMove = 1.0;
        private static double sprStrain = 1.0;
        private static double sprLength = 1.0;
        private static double sprGravitation = 1.0;
        private double largestMovement = 0.0;
        private Map<String, Integer> srcDestToNumRelsMap = new HashMap<String, Integer>();
        private Map<String, Double> srcDestToRelsAvgWeightMap = new HashMap<String, Double>();
        private static Map<String, Double> relTypeToWeightMap = new HashMap<String, Double>();
        private int iteration;
        private int[][] srcDestToNumRels;
        private double[][] srcDestToRelsAvgWeight;
        private double[] tempLocationsX;
        private double[] tempLocationsY;
        private double[] forcesX;
        private double[] forcesY;
        private boolean[] anchors;
        private DisplayIndependentRectangle bounds = null;
        @Deprecated
        Date date = new Date();
        private long startTime = 0L;

        @Deprecated
        public Zest1(int styles) {
            super(styles);
        }

        @Deprecated
        public Zest1() {
            this(0);
        }

        @Override
        @Deprecated
        public void setLayoutArea(double x, double y, double width, double height) {
            this.bounds = new DisplayIndependentRectangle(x, y, width, height);
        }

        @Deprecated
        public void setSpringMove(double move) {
            sprMove = move;
        }

        @Deprecated
        public double getSpringMove() {
            return sprMove;
        }

        @Deprecated
        public void setSpringStrain(double strain) {
            sprStrain = strain;
        }

        @Deprecated
        public double getSpringStrain() {
            return sprStrain;
        }

        @Deprecated
        public void setSpringLength(double length) {
            sprLength = length;
        }

        @Deprecated
        public long getSpringTimeout() {
            return maxTimeMS;
        }

        @Deprecated
        public void setSpringTimeout(long timeout) {
            maxTimeMS = timeout;
        }

        @Deprecated
        public double getSpringLength() {
            return sprLength;
        }

        @Deprecated
        public void setSpringGravitation(double gravitation) {
            sprGravitation = gravitation;
        }

        @Deprecated
        public double getSpringGravitation() {
            return sprGravitation;
        }

        @Deprecated
        public void setIterations(int iterations) {
            sprIterations = iterations;
        }

        @Deprecated
        public int getIterations() {
            return sprIterations;
        }

        @Deprecated
        public void setRandom(boolean random) {
            sprRandom = random;
        }

        @Deprecated
        public boolean getRandom() {
            return sprRandom;
        }

        @Deprecated
        public void setWeight(String relType, double weight) {
            relTypeToWeightMap.put(relType, weight);
        }

        @Deprecated
        public double getWeight(String relType) {
            Double weight = relTypeToWeightMap.get(relType);
            return weight == null ? 1.0 : weight;
        }

        @Deprecated
        public void setDefaultConditions() {
        }

        private void reset(InternalNode[] entitiesToLayout) {
            this.tempLocationsX = null;
            this.tempLocationsY = null;
            this.forcesX = null;
            this.forcesY = null;
            this.anchors = null;
            this.setDefaultConditions();
            this.srcDestToNumRelsMap = new HashMap<String, Integer>();
            this.srcDestToRelsAvgWeightMap = new HashMap<String, Double>();
            relTypeToWeightMap = new HashMap<String, Double>();
        }

        @Override
        @Deprecated
        protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
            this.bounds = new DisplayIndependentRectangle(x, y, width, height);
            this.tempLocationsX = new double[entitiesToLayout.length];
            this.tempLocationsY = new double[entitiesToLayout.length];
            this.forcesX = new double[entitiesToLayout.length];
            this.forcesY = new double[entitiesToLayout.length];
            this.anchors = new boolean[entitiesToLayout.length];
            int i = 0;
            while (i < entitiesToLayout.length) {
                this.anchors[i] = false;
                ++i;
            }
            InternalRelationship[] internalRelationshipArray = relationshipsToConsider;
            int n = relationshipsToConsider.length;
            int n2 = 0;
            while (n2 < n) {
                InternalRelationship layoutRelationship = internalRelationshipArray[n2];
                this.addRelation(layoutRelationship);
                ++n2;
            }
            this.preCompute(entitiesToLayout);
            this.startTime = this.date.getTime();
        }

        @Override
        @Deprecated
        protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
            this.reset(entitiesToLayout);
        }

        private void addRelation(InternalRelationship layoutRelationship) {
            String[] keys;
            if (layoutRelationship == null) {
                throw new IllegalArgumentException("The arguments can not be null!");
            }
            double weight = layoutRelationship.getWeight();
            weight = weight <= 0.0 ? 0.1 : weight;
            String key1 = layoutRelationship.getSource().toString() + layoutRelationship.getDestination().toString();
            String key2 = layoutRelationship.getDestination().toString() + layoutRelationship.getSource().toString();
            String[] stringArray = keys = new String[]{key1, key2};
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Integer count = this.srcDestToNumRelsMap.get(key);
                Double avgWeight = this.srcDestToRelsAvgWeightMap.get(key);
                if (count == null) {
                    count = 1;
                    avgWeight = weight;
                } else {
                    int newCount = count + 1;
                    double newAverage = (avgWeight * count.doubleValue() + weight) / (double)newCount;
                    avgWeight = newAverage;
                    count = newCount;
                }
                this.srcDestToNumRelsMap.put(key, count);
                this.srcDestToRelsAvgWeightMap.put(key, avgWeight);
                ++n2;
            }
        }

        private void preCompute(InternalNode[] entitiesToLayout) {
            this.srcDestToNumRels = new int[entitiesToLayout.length][entitiesToLayout.length];
            this.srcDestToRelsAvgWeight = new double[entitiesToLayout.length][entitiesToLayout.length];
            int i = 0;
            while (i < entitiesToLayout.length - 1) {
                InternalNode layoutEntity1 = entitiesToLayout[i];
                int j = i + 1;
                while (j < entitiesToLayout.length) {
                    InternalNode layoutEntity2 = entitiesToLayout[j];
                    this.srcDestToNumRels[i][j] = this.numRelations(layoutEntity1, layoutEntity2);
                    int[] nArray = this.srcDestToNumRels[i];
                    int n = j;
                    nArray[n] = nArray[n] + this.numRelations(layoutEntity2, layoutEntity1);
                    this.srcDestToRelsAvgWeight[i][j] = this.avgWeight(layoutEntity1, layoutEntity2);
                    ++j;
                }
                ++i;
            }
            if (sprRandom) {
                this.placeRandomly(entitiesToLayout);
            } else {
                this.convertToUnitCoordinates(entitiesToLayout);
            }
            this.iteration = 1;
            this.largestMovement = Double.MAX_VALUE;
        }

        @Deprecated
        protected DisplayIndependentRectangle getLayoutBoundsTemp(InternalNode[] entitiesToLayout, boolean includeNodeSize) {
            double rightSide = Double.MIN_VALUE;
            double bottomSide = Double.MIN_VALUE;
            double leftSide = Double.MAX_VALUE;
            double topSide = Double.MAX_VALUE;
            int i = 0;
            while (i < entitiesToLayout.length) {
                double x = this.tempLocationsX[i];
                double y = this.tempLocationsY[i];
                leftSide = Math.min(x, leftSide);
                topSide = Math.min(y, topSide);
                rightSide = Math.max(x, rightSide);
                bottomSide = Math.max(y, bottomSide);
                ++i;
            }
            return new DisplayIndependentRectangle(leftSide, topSide, rightSide - leftSide, bottomSide - topSide);
        }

        @Deprecated
        protected void convertNodePositionsBack(int i, InternalNode entityToConvert, double px, double py, double screenWidth, double screenHeight, DisplayIndependentRectangle layoutBounds) {
            if (px > screenWidth) {
                px = screenWidth;
            }
            if (py > screenHeight) {
                py = screenHeight;
            }
            if (px < 0.0) {
                px = 1.0;
            }
            if (py < 0.0) {
                py = 1.0;
            }
            double x = px / screenWidth * layoutBounds.width + layoutBounds.x;
            double y = py / screenHeight * layoutBounds.height + layoutBounds.y;
            this.tempLocationsX[i] = x;
            this.tempLocationsY[i] = y;
            entityToConvert.getInternalX();
        }

        private void checkPreferredLocation(InternalNode[] entitiesToLayout, DisplayIndependentRectangle realBounds) {
            double borderWidth = Math.min(realBounds.width, realBounds.height) / 10.0;
            DisplayIndependentRectangle screenBounds = new DisplayIndependentRectangle(realBounds.x + borderWidth / 2.0, realBounds.y + borderWidth / 2.0, realBounds.width - borderWidth, realBounds.height - borderWidth);
            DisplayIndependentRectangle layoutBounds = this.getLayoutBoundsTemp(entitiesToLayout, false);
            int i = 0;
            while (i < entitiesToLayout.length) {
                InternalNode layoutEntity = entitiesToLayout[i];
                if (layoutEntity.hasPreferredLocation()) {
                    this.convertNodePositionsBack(i, layoutEntity, layoutEntity.getPreferredX(), layoutEntity.getPreferredY(), screenBounds.width, screenBounds.height, layoutBounds);
                }
                ++i;
            }
        }

        private void setSprIterationsBasedOnTime() {
            if (maxTimeMS <= 0L) {
                return;
            }
            long currentTime = this.date.getTime();
            double fractionComplete = (double)(currentTime - this.startTime) / (double)maxTimeMS;
            int currentIteration = (int)(fractionComplete * (double)sprIterations);
            if (currentIteration > this.iteration) {
                this.iteration = currentIteration;
            }
        }

        @Override
        @Deprecated
        protected boolean performAnotherNonContinuousIteration() {
            this.setSprIterationsBasedOnTime();
            return this.iteration <= sprIterations && this.largestMovement >= sprMove;
        }

        @Override
        @Deprecated
        protected int getCurrentLayoutStep() {
            return this.iteration;
        }

        @Override
        @Deprecated
        protected int getTotalNumberOfLayoutSteps() {
            return sprIterations;
        }

        @Override
        @Deprecated
        protected void computeOneIteration(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
            if (this.bounds == null) {
                this.bounds = new DisplayIndependentRectangle(x, y, width, height);
            }
            this.checkPreferredLocation(entitiesToLayout, this.bounds);
            this.computeForces(entitiesToLayout);
            this.largestMovement = Double.MAX_VALUE;
            this.computePositions(entitiesToLayout);
            int i = 0;
            while (i < entitiesToLayout.length) {
                InternalNode layoutEntity = entitiesToLayout[i];
                layoutEntity.setInternalLocation(this.tempLocationsX[i], this.tempLocationsY[i]);
                ++i;
            }
            this.defaultFitWithinBounds(entitiesToLayout, this.bounds);
            ++this.iteration;
        }

        @Deprecated
        public void placeRandomly(InternalNode[] entitiesToLayout) {
            if (entitiesToLayout.length == 1) {
                this.tempLocationsX[0] = 0.5;
                this.tempLocationsY[0] = 0.5;
            } else {
                int i = 0;
                while (i < entitiesToLayout.length) {
                    if (i == 0) {
                        this.tempLocationsX[i] = 0.0;
                        this.tempLocationsY[i] = 0.0;
                    } else if (i == 1) {
                        this.tempLocationsX[i] = 1.0;
                        this.tempLocationsY[i] = 1.0;
                    } else {
                        this.tempLocationsX[i] = Math.random();
                        this.tempLocationsY[i] = Math.random();
                    }
                    ++i;
                }
            }
        }

        @Deprecated
        protected void computeForces(InternalNode[] entitiesToLayout) {
            int i = 0;
            while (i < entitiesToLayout.length) {
                this.forcesX[i] = 0.0;
                this.forcesY[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < entitiesToLayout.length - 1) {
                InternalNode sourceEntity = entitiesToLayout[i];
                double srcLocationX = this.tempLocationsX[i];
                double srcLocationY = this.tempLocationsY[i];
                double fx = this.forcesX[i];
                double fy = this.forcesY[i];
                int j = i + 1;
                while (j < entitiesToLayout.length) {
                    InternalNode destinationEntity = entitiesToLayout[j];
                    if (!destinationEntity.equals(sourceEntity)) {
                        double destLocationX = this.tempLocationsX[j];
                        double destLocationY = this.tempLocationsY[j];
                        double dx = srcLocationX - destLocationX;
                        double dy = srcLocationY - destLocationY;
                        double distance = Math.sqrt(dx * dx + dy * dy);
                        double distance_sq = distance * distance;
                        distance = Math.max(0.001, distance);
                        int numRels = this.srcDestToNumRels[i][j];
                        double avgWeight = this.srcDestToRelsAvgWeight[i][j];
                        if (numRels > 0) {
                            f = sprStrain * Math.log(distance / sprLength) * (double)numRels * avgWeight;
                            fx -= f * dx / distance;
                            fy -= f * dy / distance;
                        } else {
                            f = sprGravitation / distance_sq;
                            fx += f * dx / distance;
                            fy += f * dy / distance;
                        }
                        this.forcesX[j] = this.forcesX[j] - fx;
                        this.forcesY[j] = this.forcesY[j] - fy;
                    }
                    ++j;
                }
                this.forcesX[i] = fx;
                this.forcesY[i] = fy;
                ++i;
            }
        }

        @Deprecated
        protected void computePositions(InternalNode[] entitiesToLayout) {
            int i = 0;
            while (i < entitiesToLayout.length) {
                if (!this.anchors[i] || entitiesToLayout[i].hasPreferredLocation()) {
                    double oldX = this.tempLocationsX[i];
                    double oldY = this.tempLocationsY[i];
                    double deltaX = sprMove * this.forcesX[i];
                    double deltaY = sprMove * this.forcesY[i];
                    double maxMovement = 0.2 * sprMove;
                    deltaX = deltaX >= 0.0 ? Math.min(deltaX, maxMovement) : Math.max(deltaX, -maxMovement);
                    deltaY = deltaY >= 0.0 ? Math.min(deltaY, maxMovement) : Math.max(deltaY, -maxMovement);
                    this.largestMovement = Math.max(this.largestMovement, Math.abs(deltaX));
                    this.largestMovement = Math.max(this.largestMovement, Math.abs(deltaY));
                    double newX = oldX + deltaX;
                    double newY = oldY + deltaY;
                    this.tempLocationsX[i] = newX;
                    this.tempLocationsY[i] = newY;
                }
                ++i;
            }
        }

        @Deprecated
        protected void convertToUnitCoordinates(InternalNode[] entitiesToLayout) {
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            InternalNode[] internalNodeArray = entitiesToLayout;
            int n = entitiesToLayout.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode layoutEntity = internalNodeArray[n2];
                minX = Math.min(minX, layoutEntity.getInternalX());
                minY = Math.min(minY, layoutEntity.getInternalY());
                maxX = Math.max(maxX, layoutEntity.getInternalX());
                maxY = Math.max(maxY, layoutEntity.getInternalY());
                ++n2;
            }
            double spanX = maxX - minX;
            double spanY = maxY - minY;
            double maxSpan = Math.max(spanX, spanY);
            if (maxSpan > 0.001) {
                int i = 0;
                while (i < entitiesToLayout.length) {
                    InternalNode layoutEntity = entitiesToLayout[i];
                    double x = (layoutEntity.getInternalX() - minX) / spanX;
                    double y = (layoutEntity.getInternalY() - minY) / spanY;
                    this.tempLocationsX[i] = x;
                    this.tempLocationsY[i] = y;
                    ++i;
                }
            } else {
                this.placeRandomly(entitiesToLayout);
            }
        }

        private int numRelations(Object src, Object dest) {
            String key = src.toString() + dest.toString();
            Integer count = this.srcDestToNumRelsMap.get(key);
            return count == null ? 0 : count;
        }

        private double avgWeight(Object src, Object dest) {
            String key = src.toString() + dest.toString();
            Double avgWeight = this.srcDestToRelsAvgWeightMap.get(key);
            return avgWeight == null ? 1.0 : avgWeight;
        }

        @Override
        @Deprecated
        protected boolean isValidConfiguration(boolean asynchronous, boolean continueous) {
            return asynchronous || !continueous;
        }
    }
}

