/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.controller;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

public class PsrController
extends StyledCellLabelProvider
implements ITreeContentProvider {
    private Psr psr0;
    private Image namespaceImage = ComposerUIPluginImages.NAMESPACE.createImage();
    private Image pathImage = ComposerUIPluginImages.PACKAGE_FOLDER.createImage();
    private TreeViewer viewer;

    public PsrController(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public String getText(Object element) {
        if (element instanceof Namespace) {
            return ((Namespace)element).getNamespace();
        }
        return element == null ? "" : element.toString();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.psr0 = (Psr)newInput;
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        String text = this.getText(obj);
        StyledString styledString = new StyledString(text);
        if (obj instanceof Namespace) {
            Namespace namespace = (Namespace)obj;
            styledString.append(" (" + namespace.size() + ")", StyledString.COUNTER_STYLER);
            cell.setImage(this.namespaceImage);
        } else {
            cell.setImage(this.pathImage);
        }
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        super.update(cell);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Psr) {
            Psr psr0 = (Psr)parentElement;
            return psr0.getNamespaces().toArray();
        }
        if (parentElement instanceof Namespace) {
            Namespace model = (Namespace)parentElement;
            return model.getPaths().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        TreeItem item = null;
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ri = treeItemArray[n2];
            TreeItem[] treeItemArray2 = ri.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem i = treeItemArray2[n4];
                if (i.getData() == element) {
                    item = i;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (item != null) {
            TreeItem parent = item.getParentItem();
            if (parent == null) {
                return this.psr0;
            }
            if (parent.getData() != null) {
                return parent.getData();
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

