/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTMatcherSameVariablesAndMethods;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTSemanticMatcher;
import org.eclipse.jdt.internal.corext.dom.VarConflictVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class ControlFlowMergeCleanUpCore
extends AbstractMultiFix {
    public ControlFlowMergeCleanUpCore() {
        this(Collections.emptyMap());
    }

    public ControlFlowMergeCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.controlflow_merge");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.controlflow_merge")) {
            return new String[]{MultiFixMessages.ControlFlowMergeCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.controlflow_merge")) {
            return "if (!isValid) {\n    j++;\n}\n++i;\n\n\n";
        }
        return "if (isValid) {\n    ++i;\n} else {\n    j++;\n    i = i + 1;\n}\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.controlflow_merge")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(IfStatement visited) {
                if (visited.getElseStatement() == null) {
                    return true;
                }
                ArrayList<List<Statement>> allCasesStatements = new ArrayList<List<Statement>>();
                ArrayList<ASTNode> allCases = new ArrayList<ASTNode>();
                if (this.collectAllCases(allCasesStatements, visited, allCases)) {
                    List[] allCaseStmtsToRemove = new List[allCasesStatements.size()];
                    int i = 0;
                    while (i < allCasesStatements.size()) {
                        allCaseStmtsToRemove[i] = new LinkedList();
                        ++i;
                    }
                    ASTMatcherSameVariablesAndMethods matcher = new ASTMatcherSameVariablesAndMethods();
                    List<Integer> casesToRefactor = this.getMatchingCases(allCasesStatements, matcher);
                    if (casesToRefactor == null || casesToRefactor.size() <= 1) {
                        return true;
                    }
                    int smallestStatementNumber = this.smallestStatementNumber(allCasesStatements, casesToRefactor);
                    int stmtIndex = 1;
                    while (stmtIndex <= smallestStatementNumber) {
                        if (!this.match(matcher, allCasesStatements, stmtIndex, casesToRefactor)) break;
                        this.flagStmtsToRemove(allCasesStatements, stmtIndex, allCaseStmtsToRemove, casesToRefactor);
                        ++stmtIndex;
                    }
                    if (!this.hasVariableConflict(visited, allCaseStmtsToRemove)) {
                        rewriteOperations.add(new ControlFlowMergeOperation(visited, allCases, allCasesStatements, allCaseStmtsToRemove, casesToRefactor));
                        return false;
                    }
                }
                return true;
            }

            private List<Integer> getMatchingCases(List<List<Statement>> allCasesStatements, ASTSemanticMatcher matcher) {
                ArrayList<StatementAndBlockIndices> matchingCases = new ArrayList<StatementAndBlockIndices>();
                int i = 0;
                while (i < allCasesStatements.size()) {
                    boolean isMatching = false;
                    Statement currentStatement = allCasesStatements.get(i).get(allCasesStatements.get(i).size() - 1);
                    for (StatementAndBlockIndices pair : matchingCases) {
                        if (!ASTNodes.match(matcher, (ASTNode)pair.getStatement(), (ASTNode)currentStatement)) continue;
                        pair.getBlockIndices().add(i);
                        isMatching = true;
                        break;
                    }
                    if (!isMatching) {
                        StatementAndBlockIndices newPair = new StatementAndBlockIndices(currentStatement, new ArrayList<Integer>());
                        newPair.getBlockIndices().add(i);
                        matchingCases.add(newPair);
                    }
                    ++i;
                }
                Collections.sort(matchingCases, Comparator.comparing(s -> s.getBlockIndices().size()));
                StatementAndBlockIndices notFallingThroughCase = null;
                for (StatementAndBlockIndices matchingCase : matchingCases) {
                    if (ASTNodes.fallsThrough(matchingCase.getStatement())) continue;
                    if (notFallingThroughCase != null) {
                        return null;
                    }
                    notFallingThroughCase = matchingCase;
                }
                if (notFallingThroughCase != null) {
                    return notFallingThroughCase.getBlockIndices();
                }
                return ((StatementAndBlockIndices)matchingCases.get(0)).getBlockIndices();
            }

            private void flagStmtsToRemove(List<List<Statement>> allCasesStatements, int stmtIndex, List<Statement>[] caseStmtsToRemove, List<Integer> casesToRefactor) {
                for (int i : casesToRefactor) {
                    List<Statement> caseStatements = allCasesStatements.get(i);
                    Statement stmtToRemove = caseStatements.get(caseStatements.size() - stmtIndex);
                    caseStmtsToRemove[i].add(stmtToRemove);
                }
            }

            private boolean match(ASTSemanticMatcher matcher, List<List<Statement>> allCasesStatements, int stmtIndex, List<Integer> casesToRefactor) {
                List<Statement> firstCaseToRefactor = allCasesStatements.get(casesToRefactor.get(0));
                int i = 1;
                while (i < casesToRefactor.size()) {
                    List<Statement> anotherCaseToRefactor = allCasesStatements.get(casesToRefactor.get(i));
                    if (!ASTNodes.match(matcher, (ASTNode)firstCaseToRefactor.get(firstCaseToRefactor.size() - stmtIndex), (ASTNode)anotherCaseToRefactor.get(anotherCaseToRefactor.size() - stmtIndex))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private int smallestStatementNumber(List<List<Statement>> allCasesStatements, List<Integer> casesToRefactor) {
                int min = allCasesStatements.get(casesToRefactor.get(0)).size();
                for (Integer caseToRefactor : casesToRefactor) {
                    List<Statement> statements = allCasesStatements.get(caseToRefactor);
                    min = Math.min(min, statements.size());
                }
                return min;
            }

            private boolean collectAllCases(List<List<Statement>> allCasesStatements, IfStatement visited, List<ASTNode> allCases) {
                IfStatement ifStatement;
                List<Statement> thenStatements = ASTNodes.asList(visited.getThenStatement());
                List<Statement> elseStatements = ASTNodes.asList(visited.getElseStatement());
                if (thenStatements.isEmpty() || elseStatements.isEmpty()) {
                    return false;
                }
                allCases.add((ASTNode)visited);
                allCasesStatements.add(thenStatements);
                if (elseStatements.size() == 1 && (ifStatement = ASTNodes.as(elseStatements.get(0), IfStatement.class)) != null) {
                    return this.collectAllCases(allCasesStatements, ifStatement, allCases);
                }
                allCases.add((ASTNode)visited.getElseStatement());
                allCasesStatements.add(elseStatements);
                return true;
            }

            private boolean hasVariableConflict(IfStatement visited, List<Statement>[] allCaseStatementsToRemove) {
                HashSet<SimpleName> ifVariableNames = new HashSet<SimpleName>();
                List<Statement>[] listArray = allCaseStatementsToRemove;
                int n = allCaseStatementsToRemove.length;
                int n2 = 0;
                while (n2 < n) {
                    List<Statement> caseStatementsToRemove = listArray[n2];
                    for (Statement statementToRemove : caseStatementsToRemove) {
                        ifVariableNames.addAll(ASTNodes.getLocalVariableIdentifiers((ASTNode)statementToRemove, false));
                    }
                    ++n2;
                }
                VarConflictVisitor varOccurrenceVisitor = new VarConflictVisitor(ifVariableNames, true);
                for (Statement furtherStatement : ASTNodes.getNextSiblings((Statement)visited)) {
                    varOccurrenceVisitor.traverseNodeInterruptibly((ASTNode)furtherStatement);
                    if (!varOccurrenceVisitor.isVarConflicting()) continue;
                    return true;
                }
                return false;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.ControlFlowMergeCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class ControlFlowMergeOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final IfStatement visited;
        private final List<ASTNode> allCases;
        private final List<List<Statement>> allCasesStatements;
        private final List<Statement>[] caseStatementsToPullDown;
        private final List<Integer> casesToRefactor;

        public ControlFlowMergeOperation(IfStatement visited, List<ASTNode> allCases, List<List<Statement>> allCasesStatements, List<Statement>[] caseStatementsToPullDown, List<Integer> casesToRefactor) {
            this.visited = visited;
            this.allCases = allCases;
            this.allCasesStatements = allCasesStatements;
            this.caseStatementsToPullDown = caseStatementsToPullDown;
            this.casesToRefactor = casesToRefactor;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ControlFlowMergeCleanUp_description, cuRewrite);
            boolean[] areCasesToRemove = new boolean[this.allCasesStatements.size()];
            Arrays.fill(areCasesToRemove, false);
            ArrayList<Statement> statementsToRemove = new ArrayList<Statement>();
            this.flagCasesAndStatementsToRemove(areCasesToRemove, statementsToRemove);
            List<Statement> oneCaseToPullDown = this.caseStatementsToPullDown[this.casesToRefactor.get(0)];
            if (this.allRemovable(areCasesToRemove, 0)) {
                if (ASTNodes.canHaveSiblings((Statement)this.visited)) {
                    this.insertIdenticalCode(rewrite, group, oneCaseToPullDown);
                    ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.visited, group);
                } else {
                    orderedStatements = new ArrayList<Statement>(oneCaseToPullDown.size());
                    for (Statement statementToPullDown : oneCaseToPullDown) {
                        orderedStatements.add(0, ASTNodes.createMoveTarget(rewrite, statementToPullDown));
                    }
                    newBlock = ast.newBlock();
                    newBlock.statements().addAll(orderedStatements);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newBlock, group);
                }
            } else {
                newBlock = this.casesToRefactor.iterator();
                while (newBlock.hasNext()) {
                    int i = newBlock.next();
                    ASTNode parent = this.allCases.get(i);
                    if (!areCasesToRemove[i]) continue;
                    if (i == areCasesToRemove.length - 2 && !areCasesToRemove[i + 1]) {
                        IfStatement newIfStatement = ast.newIfStatement();
                        newIfStatement.setExpression(ASTNodeFactory.negate(ast, rewrite, ((IfStatement)parent).getExpression(), true));
                        newIfStatement.setThenStatement(ASTNodes.createMoveTarget(rewrite, ((IfStatement)parent).getElseStatement()));
                        ASTNodes.replaceButKeepComment(rewrite, parent, (ASTNode)newIfStatement, group);
                        break;
                    }
                    if (this.allRemovable(areCasesToRemove, i)) {
                        rewrite.remove(parent, group);
                        break;
                    }
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)((IfStatement)parent).getThenStatement(), (ASTNode)ast.newBlock(), group);
                }
                if (ASTNodes.canHaveSiblings((Statement)this.visited)) {
                    this.insertIdenticalCode(rewrite, group, oneCaseToPullDown);
                } else {
                    orderedStatements = new ArrayList(oneCaseToPullDown.size() + 1);
                    for (Statement stmtToRemove : oneCaseToPullDown) {
                        orderedStatements.add(0, ASTNodes.createMoveTarget(rewrite, stmtToRemove));
                    }
                    orderedStatements.add(0, (Statement)ASTNodes.createMoveTarget(rewrite, this.visited));
                    newBlock = ast.newBlock();
                    newBlock.statements().addAll(orderedStatements);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newBlock, group);
                }
            }
            for (Statement statementToRemove : statementsToRemove) {
                rewrite.remove((ASTNode)statementToRemove, group);
            }
        }

        private void insertIdenticalCode(ASTRewrite rewrite, TextEditGroup group, List<Statement> statementsToPullDown) {
            Statement moveTarget;
            if (statementsToPullDown.size() == 1) {
                moveTarget = ASTNodes.createMoveTarget(rewrite, statementsToPullDown.get(0));
            } else {
                ListRewrite listRewrite = rewrite.getListRewrite(statementsToPullDown.get(0).getParent(), (ChildListPropertyDescriptor)statementsToPullDown.get(0).getLocationInParent());
                moveTarget = listRewrite.createMoveTarget((ASTNode)statementsToPullDown.get(statementsToPullDown.size() - 1), (ASTNode)statementsToPullDown.get(0));
            }
            ListRewrite targetListRewrite = rewrite.getListRewrite(this.visited.getParent(), (ChildListPropertyDescriptor)this.visited.getLocationInParent());
            targetListRewrite.insertAfter((ASTNode)moveTarget, (ASTNode)this.visited, group);
        }

        private boolean allRemovable(boolean[] areCasesRemovable, int start) {
            int i = start;
            while (i < areCasesRemovable.length) {
                if (!areCasesRemovable[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void flagCasesAndStatementsToRemove(boolean[] areCasesRemovable, List<Statement> statementsToRemove) {
            boolean isFirstCase = true;
            for (int i : this.casesToRefactor) {
                List<Statement> removedStatements = this.caseStatementsToPullDown[i];
                ASTNode parent = this.allCases.get(i);
                if (removedStatements.containsAll((Collection)this.allCasesStatements.get(i)) && (!(parent instanceof IfStatement) || ASTNodes.isPassiveWithoutFallingThrough((ASTNode)((IfStatement)parent).getExpression()))) {
                    areCasesRemovable[i] = true;
                } else if (!isFirstCase) {
                    statementsToRemove.addAll(removedStatements);
                }
                isFirstCase = false;
            }
        }
    }

    private static final class StatementAndBlockIndices {
        private final Statement statement;
        private final List<Integer> blockIndices;

        private StatementAndBlockIndices(Statement statement, List<Integer> blockIndices) {
            this.statement = statement;
            this.blockIndices = blockIndices;
        }

        private Statement getStatement() {
            return this.statement;
        }

        private List<Integer> getBlockIndices() {
            return this.blockIndices;
        }
    }
}

