/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.blame.BlameOperation;
import org.eclipse.egit.ui.internal.blame.BlameRevision;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

public class BlameInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private IVerticalRulerInfo rulerInfo;
    private BlameRevision revision;
    private ScrolledComposite scrolls;
    private Composite displayArea;
    private Label commitLabel;
    private Label authorLabel;
    private Label committerLabel;
    private StyledText messageText;
    private int revisionRulerLineNumber = -1;
    private Composite diffComposite;
    private Link showAnnotationsLink;
    private SelectionAdapter showAnnotationsLinkSelectionAdapter;
    private IAction openCommit;
    private IAction showInHistory;
    private boolean expectLineNumberInRevision;
    private IInformationControlCreator createEnriched;

    public BlameInformationControl(Shell parentShell, IVerticalRulerInfo rulerInfo) {
        super(parentShell, EditorsUI.getTooltipAffordanceString());
        this.rulerInfo = rulerInfo;
        this.create();
    }

    BlameInformationControl(Shell parentShell, IVerticalRulerInfo rulerInfo, boolean expectLineNumberInRevision) {
        super(parentShell, new ToolBarManager(0x800000));
        this.expectLineNumberInRevision = expectLineNumberInRevision;
        this.create();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.createEnriched == null) {
            this.createEnriched = parentShell -> new BlameInformationControl(parentShell, this.rulerInfo, true);
        }
        return this.createEnriched;
    }

    public boolean hasContents() {
        return true;
    }

    protected void createContent(Composite parent) {
        this.scrolls = new ScrolledComposite(parent, 768);
        this.scrolls.setExpandHorizontal(true);
        this.scrolls.setExpandVertical(true);
        this.displayArea = new Composite((Composite)this.scrolls, 0);
        this.scrolls.setContent((Control)this.displayArea);
        this.displayArea.setForeground(parent.getForeground());
        this.displayArea.setBackground(parent.getBackground());
        this.displayArea.setBackgroundMode(2);
        GridLayoutFactory.swtDefaults().equalWidth(true).applyTo(this.displayArea);
        Composite commitHeader = new Composite(this.displayArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(commitHeader);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)commitHeader);
        this.commitLabel = new Label(commitHeader, 8);
        this.commitLabel.setFont(JFaceResources.getBannerFont());
        Link openCommitLink = new Link(commitHeader, 0);
        openCommitLink.setText(UIText.BlameInformationControl_OpenCommitLink);
        openCommitLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlameInformationControl.this.openCommit();
            }
        });
        Link showInHistoryLink = new Link(commitHeader, 0);
        showInHistoryLink.setText(UIText.BlameInformationControl_ShowInHistoryLink);
        showInHistoryLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlameInformationControl.this.showCommitInHistory();
            }
        });
        this.authorLabel = new Label(this.displayArea, 0);
        this.authorLabel.setForeground(parent.getForeground());
        this.authorLabel.setBackground(parent.getBackground());
        this.authorLabel.setFont(UIUtils.getItalicFont("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.authorLabel);
        this.committerLabel = new Label(this.displayArea, 0);
        this.committerLabel.setForeground(parent.getForeground());
        this.committerLabel.setBackground(parent.getBackground());
        this.committerLabel.setFont(UIUtils.getItalicFont("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.committerLabel);
        Label separator = new Label(this.displayArea, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        this.messageText = new StyledText(this.displayArea, 0);
        this.messageText.setForeground(parent.getForeground());
        this.messageText.setBackground(parent.getBackground());
        this.messageText.setEditable(false);
        this.messageText.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.messageText);
        separator = new Label(this.displayArea, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        ToolBarManager toolbar = this.getToolBarManager();
        if (toolbar != null) {
            this.openCommit = new Action(UIText.BlameInformationControl_OpenCommitLabel, UIIcons.OPEN_COMMIT){

                public void run() {
                    BlameInformationControl.this.openCommit();
                }
            };
            toolbar.add(this.openCommit);
            this.showInHistory = new Action(UIText.BlameInformationControl_ShowInHistoryLabel, UIIcons.HISTORY){

                public void run() {
                    BlameInformationControl.this.showCommitInHistory();
                }
            };
            toolbar.add(this.showInHistory);
            toolbar.update(true);
        }
    }

    public Point computeSizeHint() {
        Point computed = this.getShell().computeSize(-1, -1, true);
        Point constraints = this.getSizeConstraints();
        if (constraints == null) {
            return computed;
        }
        Point constrainedSize = this.getShell().computeSize(constraints.x, -1, true);
        int width = Math.min(computed.x, constrainedSize.x);
        int height = Math.max(computed.y, constrainedSize.y);
        return new Point(width, height);
    }

    private void setControlVisible(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    public void setInput(Object input) {
        if (input == null) {
            this.revision = null;
            if (this.showAnnotationsLink != null) {
                if (!this.showAnnotationsLink.isDisposed()) {
                    this.showAnnotationsLink.removeSelectionListener((SelectionListener)this.showAnnotationsLinkSelectionAdapter);
                }
                this.showAnnotationsLink = null;
                this.showAnnotationsLinkSelectionAdapter = null;
            }
            return;
        }
        this.revision = (BlameRevision)((Object)input);
        if (this.expectLineNumberInRevision) {
            this.revisionRulerLineNumber = this.revision.getActiveLineNumber();
        }
        if (this.rulerInfo != null && this.revisionRulerLineNumber < 0) {
            this.revisionRulerLineNumber = this.rulerInfo.getLineOfLastMouseButtonActivity();
            this.revision.setActiveLineNumber(this.revisionRulerLineNumber);
        }
        RevCommit commit = this.revision.getCommit();
        String linkText = MessageFormat.format(UIText.BlameInformationControl_Commit, Utils.getShortObjectId((ObjectId)commit));
        this.commitLabel.setText(linkText);
        PreferenceBasedDateFormatter dateFormatter = PreferenceBasedDateFormatter.create();
        PersonIdent author = commit.getAuthorIdent();
        if (author != null) {
            this.setControlVisible((Control)this.authorLabel, true);
            this.authorLabel.setText(MessageFormat.format(UIText.BlameInformationControl_Author, author.getName(), author.getEmailAddress(), dateFormatter.formatDate(author)));
        } else {
            this.setControlVisible((Control)this.authorLabel, false);
        }
        PersonIdent committer = commit.getCommitterIdent();
        this.setControlVisible((Control)this.authorLabel, author != null);
        if (committer != null && !committer.equals((Object)author)) {
            this.setControlVisible((Control)this.committerLabel, true);
            this.committerLabel.setText(MessageFormat.format(UIText.BlameInformationControl_Committer, committer.getName(), committer.getEmailAddress(), dateFormatter.formatDate(committer)));
        } else {
            this.setControlVisible((Control)this.committerLabel, false);
        }
        this.messageText.setText(commit.getFullMessage());
        this.createDiffs();
        if (this.openCommit != null) {
            this.openCommit.setToolTipText(MessageFormat.format(UIText.BlameInformationControl_OpenCommitTooltip, Utils.getShortObjectId((ObjectId)commit)));
        }
        this.displayArea.layout();
        this.scrolls.setMinSize(this.displayArea.computeSize(-1, -1));
    }

    private void createDiffs() {
        RevCommit commit;
        if (this.diffComposite != null) {
            this.diffComposite.dispose();
        }
        if ((commit = this.revision.getCommit()).getParentCount() == 0) {
            return;
        }
        this.createDiffComposite();
        int i = 0;
        while (i < commit.getParentCount()) {
            RevCommit parent = commit.getParent(i);
            this.createDiff(parent);
            ++i;
        }
    }

    private void createDiffComposite() {
        this.diffComposite = new Composite(this.displayArea, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.diffComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.diffComposite);
    }

    private void createDiff(RevCommit parent) {
        BlameRevision.Diff diff = this.revision.getDiffToParent(parent);
        if (diff != null) {
            try {
                this.createDiffLinkAndText(parent, diff);
            }
            catch (IOException e) {
                String msg = "Error creating diff in blame information control for commit " + String.valueOf(parent.toObjectId());
                Activator.logError(msg, e);
            }
        }
    }

    private void createDiffLinkAndText(final RevCommit parent, final BlameRevision.Diff diff) throws IOException {
        String parentId = Utils.getShortObjectId((ObjectId)parent.toObjectId());
        String parentMessage = parent.getShortMessage();
        EditList interestingDiff = this.getInterestingDiff(diff.getEditList());
        final Integer parentLine = !interestingDiff.isEmpty() ? Integer.valueOf(((Edit)interestingDiff.get(0)).getBeginA()) : null;
        Composite header = new Composite(this.diffComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(header);
        Label diffHeaderLabel = new Label(header, 0);
        diffHeaderLabel.setText(NLS.bind((String)UIText.BlameInformationControl_DiffHeaderLabel, (Object)parentId, (Object)parentMessage));
        this.showAnnotationsLink = new Link(header, 0);
        this.showAnnotationsLink.setText(UIText.BlameInformationControl_ShowAnnotationsLink);
        this.showAnnotationsLinkSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlameInformationControl.this.blameParent(parent, diff, parentLine);
            }
        };
        this.showAnnotationsLink.addSelectionListener((SelectionListener)this.showAnnotationsLinkSelectionAdapter);
        DiffViewer diffText = new DiffViewer(this.diffComposite, null, 0);
        diffText.configure((SourceViewerConfiguration)new DiffViewer.Configuration(EditorsUI.getPreferenceStore()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(diffText.getControl());
        DiffDocument document = new DiffDocument();
        Throwable throwable = null;
        Object var12_13 = null;
        try (DiffRegionFormatter diffFormatter = new DiffRegionFormatter((IDocument)document);){
            diffFormatter.setContext(1);
            diffFormatter.setRepository(this.revision.getRepository());
            diffFormatter.format(interestingDiff, diff.getOldText(), diff.getNewText());
            try {
                int lastLineLength;
                int nLines = document.getNumberOfLines();
                if (nLines > 0 && (lastLineLength = document.getLineLength(nLines - 1)) == 0) {
                    int lineStart = document.getLineOffset(nLines - 1);
                    document.set(document.get(0, lineStart - 1));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            Throwable throwable2 = null;
            Object var15_21 = null;
            try (ObjectReader reader = this.revision.getRepository().newObjectReader();){
                DiffEntry diffEntry = CompareCoreUtils.getChangeDiffEntry((Repository)this.revision.getRepository(), (String)this.revision.getSourcePath(), (RevCommit)this.revision.getCommit(), (RevCommit)parent, (ObjectReader)reader);
                if (diffEntry != null) {
                    FileDiff fileDiff = new FileDiff(this.revision.getRepository(), this.revision.getCommit(), diffEntry);
                    document.setDefault(fileDiff);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            document.connect(diffFormatter);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        diffText.setDocument((IDocument)document);
    }

    private EditList getInterestingDiff(EditList fullDiff) {
        int hoverLineNumber = this.getHoverLineNumber();
        Integer sourceLine = this.revision.getSourceLine(hoverLineNumber);
        if (sourceLine == null) {
            return fullDiff;
        }
        int line = sourceLine;
        EditList interestingDiff = new EditList(1);
        for (Edit edit : fullDiff) {
            if (line < edit.getBeginB() || line > edit.getEndB()) continue;
            interestingDiff.add((Object)edit);
        }
        return interestingDiff;
    }

    int getHoverLineNumber() {
        return this.revisionRulerLineNumber;
    }

    private void openCommit() {
        try {
            this.getShell().dispose();
            CommitEditor.open(new RepositoryCommit(this.revision.getRepository(), this.revision.getCommit()));
        }
        catch (PartInitException pie) {
            Activator.logError(pie.getLocalizedMessage(), pie);
        }
    }

    private void showCommitInHistory() {
        IHistoryView part;
        this.getShell().dispose();
        try {
            part = (IHistoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
        }
        catch (PartInitException e) {
            Activator.logError(e.getLocalizedMessage(), e);
            return;
        }
        if (part == null) {
            return;
        }
        Repository repository = this.revision.getRepository();
        if (!repository.isBare()) {
            String sourcePath = this.revision.getSourcePath();
            File file = new File(repository.getWorkTree(), sourcePath);
            BlameOperation.BlameHistoryPageInput input = new BlameOperation.BlameHistoryPageInput(repository, this.revision.getCommit(), file);
            part.showHistoryFor((Object)input);
        } else {
            BlameOperation.BlameHistoryPageInput input = new BlameOperation.BlameHistoryPageInput(repository, this.revision.getCommit());
            part.showHistoryFor((Object)input);
        }
    }

    private void blameParent(RevCommit parent, BlameRevision.Diff diff, Integer sourceLine) {
        try {
            int line;
            String path = diff.getOldPath();
            IFileRevision rev = CompareUtils.getFileRevision(path, parent, this.revision.getRepository(), null);
            int n = line = sourceLine == null ? -1 : sourceLine;
            if (rev instanceof CommitFileRevision) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                BlameOperation operation = new BlameOperation((CommitFileRevision)rev, this.getShell(), page, line);
                JobUtil.scheduleUserJob((IEGitOperation)operation, (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.ShowBlameHandler_errorMessage, e);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setInput(null);
        }
    }
}

