/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.util;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.util.XmlStreamWriter;

public class MarkupToDocbook {
    private String bookTitle;
    private MarkupLanguage markupLanguage;

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public String parse(String markupContent) throws Exception {
        if (this.markupLanguage == null) {
            throw new IllegalStateException("must set markupLanguage");
        }
        StringWriter out = new StringWriter();
        DocBookDocumentBuilder builder = new DocBookDocumentBuilder(out){

            @Override
            protected XmlStreamWriter createXmlStreamWriter(Writer out) {
                return super.createFormattingXmlStreamWriter(out);
            }
        };
        builder.setBookTitle(this.bookTitle);
        MarkupParser markupParser = new MarkupParser();
        markupParser.setBuilder(builder);
        markupParser.setMarkupLanguage(this.markupLanguage);
        markupParser.parse(markupContent);
        return out.toString();
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }
}

