/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class MultipleTaskHyperlinkDetector
extends TaskHyperlinkDetector {
    @Override
    protected List<IHyperlink> detectHyperlinks(ITextViewer textViewer, String content, int index, int contentOffset) {
        ArrayList<IHyperlink> result = new ArrayList<IHyperlink>();
        TaskRepository currentRepository = this.getTaskRepository(textViewer);
        IHyperlink[] currentRepositoryLinks = this.detectHyperlinks(currentRepository, content, index, contentOffset);
        if (currentRepositoryLinks != null && currentRepositoryLinks.length > 0) {
            result.addAll(Arrays.asList(currentRepositoryLinks));
            HashSet<Region> currentRepositoryRegions = new HashSet<Region>();
            IHyperlink[] iHyperlinkArray = currentRepositoryLinks;
            int n = currentRepositoryLinks.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlink link = iHyperlinkArray[n2];
                currentRepositoryRegions.add(this.getRegion(link));
                ++n2;
            }
            List<TaskRepository> otherRepositories = this.getTaskRepositories(textViewer);
            otherRepositories.remove(currentRepository);
            for (TaskRepository repository : otherRepositories) {
                IHyperlink[] links = this.detectHyperlinks(repository, content, index, contentOffset);
                if (links == null) continue;
                IHyperlink[] iHyperlinkArray2 = links;
                int n3 = links.length;
                int n4 = 0;
                while (n4 < n3) {
                    IHyperlink link = iHyperlinkArray2[n4];
                    if (currentRepositoryRegions.contains(this.getRegion(link))) {
                        result.add(link);
                    }
                    ++n4;
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    protected Region getRegion(IHyperlink link) {
        if (link.getHyperlinkRegion() instanceof Region) {
            return (Region)link.getHyperlinkRegion();
        }
        return new Region(link.getHyperlinkRegion().getOffset(), link.getHyperlinkRegion().getLength());
    }

    @Override
    protected List<TaskRepository> getTaskRepositories(ITextViewer textViewer) {
        return TasksUi.getRepositoryManager().getAllRepositories();
    }
}

