/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.pyocd.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.core.DynamicVariableResolver;
import org.eclipse.embedcdt.internal.debug.gdbjtag.pyocd.core.Activator;

public class Configuration {
    public static String getSymbolsFileName(ILaunchConfiguration config) {
        IPath programPath;
        block6: {
            try {
                ICProject cproject = LaunchUtils.getCProject((ILaunchConfiguration)config);
                programPath = LaunchUtils.verifyProgramPath((ILaunchConfiguration)config, (ICProject)cproject);
                if (programPath != null) break block6;
                return null;
            }
            catch (CoreException e) {
                return null;
            }
        }
        String symbolsFileName = null;
        if (config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true)) {
            if (programPath != null) {
                symbolsFileName = programPath.toOSString();
            }
        } else {
            symbolsFileName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
            symbolsFileName = !symbolsFileName.isEmpty() ? DebugUtils.resolveAll((String)symbolsFileName, (Map)config.getAttributes()) : null;
        }
        return symbolsFileName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getGdbServerCommand(ILaunchConfiguration configuration, String executable) {
        block3: {
            try {
                if (executable != null) return Configuration.resolveAll(executable, configuration);
                if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", true)) break block3;
                return null;
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
                return null;
            }
        }
        executable = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", "${pyocd_path}/${pyocd_executable}");
        return Configuration.resolveAll(executable, configuration);
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbServerCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        String symbolsFilePath;
        String executable;
        ArrayList<String> lst;
        block32: {
            block31: {
                lst = new ArrayList<String>();
                try {
                    if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", true)) break block31;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log((Throwable)e);
                    return null;
                }
            }
            executable = Configuration.getGdbServerCommand(configuration, null);
            if (executable != null && !executable.isEmpty()) break block32;
            return null;
        }
        lst.add(executable);
        lst.add("gdbserver");
        lst.add("--no-wait");
        lst.add("-j");
        lst.add(DebugUtils.getProjectOsPath((ILaunchConfiguration)configuration).toOSString());
        lst.add("--port");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", 3333)));
        lst.add("--telnet-port");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", 4444)));
        String boardId = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", "");
        if (!boardId.isEmpty()) {
            lst.add("--uid");
            lst.add(boardId);
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", false)) {
            lst.add("--target");
            lst.add(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", ""));
        }
        lst.add("--frequency");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", 1000000)));
        int connectMode = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerConnectMode", 0);
        switch (connectMode) {
            case 0: {
                lst.add("--connect=halt");
                break;
            }
            case 1: {
                lst.add("--connect=pre-reset");
                break;
            }
            case 2: {
                lst.add("--connect=under-reset");
                break;
            }
            case 3: {
                lst.add("--connect=attach");
            }
        }
        int resetType = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerResetType", 0);
        switch (resetType) {
            case 0: {
                lst.add("-Oreset_type=default");
                break;
            }
            case 1: {
                lst.add("-Oreset_type=hw");
                break;
            }
            case 2: {
                lst.add("-Oreset_type=sw");
                break;
            }
            case 3: {
                lst.add("-Oreset_type=sw_sysresetreq");
                break;
            }
            case 4: {
                lst.add("-Oreset_type=sw_vectreset");
                break;
            }
            case 5: {
                lst.add("-Oreset_type=sw_emulated");
            }
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", true)) {
            lst.add("-Ch");
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", false)) {
            lst.add("--Ostep_into_interrupt");
        }
        int flashMode = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", 2);
        switch (flashMode) {
            case 0: {
                lst.add("--erase=auto");
                break;
            }
            case 1: {
                lst.add("--erase=chip");
                break;
            }
            case 2: {
                lst.add("--erase=sector");
            }
        }
        boolean boolValue = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerSmartFlash", true);
        lst.add("-Osmart_flash=" + (boolValue ? "1" : "0"));
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", true)) {
            lst.add("--semihosting");
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", false)) {
            lst.add("--Osemihost_use_syscalls");
        }
        if ((symbolsFilePath = Configuration.getSymbolsFileName(configuration)) != null) {
            lst.add("--elf");
            lst.add(symbolsFilePath);
        }
        String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", "").trim();
        if (!(other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes())).isEmpty()) {
            lst.addAll(StringUtils.splitCommandLineOptions((String)other));
        }
        lst.add("-c");
        lst.add("echo \"" + Configuration.getGdbServerStartedMessage() + "\"");
        return lst.toArray(new String[0]);
    }

    public static String getGdbServerCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbServerCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String getGdbServerOtherConfig(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", "").trim();
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration, String executable) {
        try {
            if (executable == null) {
                String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
                executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            }
            executable = DebugUtils.resolveAll((String)executable, (Map)configuration.getAttributes());
            executable = Configuration.resolveAll(executable, configuration);
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return executable;
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = Configuration.getGdbClientCommand(configuration, null);
        if (executable == null || executable.isEmpty()) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", "").trim();
            other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
            if (!other.isEmpty()) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbClientCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String getGdbClientCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbClientCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String resolveAll(String str, ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String value = str;
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        if (value.indexOf("${") >= 0 && (project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration)) != null) {
            value = DynamicVariableResolver.resolveAll(value, project);
        }
        if (value.indexOf("${") >= 0) {
            value = DebugUtils.resolveAll((String)value, (Map)configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                value = DebugUtils.resolveAll((String)value, (ICConfigurationDescription)buildConfig);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.resolveAll(\"" + str + "\") = \"" + value + "\"");
        }
        return value;
    }

    public static boolean getDoStartGdbServer(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", true);
    }

    public static boolean getDoAddServerConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", true);
    }

    public static boolean getDoAddSemihostingConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", true);
    }

    public static String getGdbServerStartedMessage() {
        return "Started by Eclipse Embedded CDT";
    }
}

