/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.packs.ui.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.embedcdt.internal.packs.ui.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.data.DataManager;
import org.eclipse.embedcdt.packs.core.data.DataManagerEvent;
import org.eclipse.embedcdt.packs.core.data.DurationMonitor;
import org.eclipse.embedcdt.packs.core.data.IDataManagerListener;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.ui.views.NodeViewContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DevicesView
extends ViewPart
implements IDataManagerListener {
    public static final String ID = "org.eclipse.embedcdt.internal.packs.ui.views.DevicesView";
    private TreeViewer fViewer;
    private Action fRemoveFilters;
    private Action fExpandAll;
    private Action fCollapseAll;
    private ViewContentProvider fContentProvider;
    private DataManager fDataManager;
    private IConsoleStream fOut = Activator.getInstance().getConsoleOutput();

    public DevicesView() {
        this.fDataManager = DataManager.getInstance();
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 66306);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fViewer);
        this.fContentProvider = new ViewContentProvider();
        this.fDataManager.addListener((IDataManagerListener)this);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.fViewer.setComparator((ViewerComparator)new NameComparator());
        this.fViewer.setInput((Object)this.getDevicesTree());
        this.addProviders();
        this.addListners();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void dispose() {
        super.dispose();
        this.fDataManager.removeListener((IDataManagerListener)this);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DevicesView.dispose()");
        }
    }

    private void addProviders() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void addListners() {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DevicesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fRemoveFilters);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fRemoveFilters);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fRemoveFilters);
    }

    private void makeActions() {
        this.fRemoveFilters = new Action(){

            public void run() {
                DevicesView.this.fViewer.setSelection(null);
            }
        };
        this.fRemoveFilters.setText("Remove filters");
        this.fRemoveFilters.setToolTipText("Remove all filters based on selections");
        this.fRemoveFilters.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/removeall.png"));
        this.fExpandAll = new Action(){

            public void run() {
                DevicesView.this.fViewer.expandAll();
            }
        };
        this.fExpandAll.setText("Expand all");
        this.fExpandAll.setToolTipText("Expand all children nodes");
        this.fExpandAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/expandall.png"));
        this.fCollapseAll = new Action(){

            public void run() {
                DevicesView.this.fViewer.collapseAll();
            }
        };
        this.fCollapseAll.setText("Collapse all");
        this.fCollapseAll.setToolTipText("Collapse all children nodes");
        this.fCollapseAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.packs.ui", (String)"icons/collapseall.png"));
    }

    private void hookDoubleClickAction() {
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void refresh(Object obj) {
        if (obj instanceof Collection) {
            for (Object node : (Collection)obj) {
                this.fViewer.refresh(node);
            }
        } else {
            this.fViewer.refresh(obj);
        }
        this.fViewer.setSelection(this.fViewer.getSelection());
    }

    public void update(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object node : list) {
                this.fViewer.update(node, null);
            }
        } else {
            this.fViewer.update(obj, null);
        }
    }

    public String toString() {
        return "DevicesView";
    }

    public void packsChanged(DataManagerEvent event) {
        String type = event.getType();
        if ("new.input".equals(type)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DevicesView.this.fViewer.setInput((Object)DevicesView.this.getDevicesTree());
                }
            });
        } else if ("update.versions".equals(type)) {
            final HashMap<String, Leaf> updatedMap = new HashMap<String, Leaf>();
            this.updateDevicesTree(updatedMap);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DevicesView.this.refresh(updatedMap.values());
                }
            });
        }
    }

    private Node getDevicesTree() {
        final Node packsTree = this.fDataManager.getRepositoriesTree();
        final Node devicesRoot = new Node("root");
        devicesRoot.setName("Devices");
        if (packsTree.hasChildren()) {
            new DurationMonitor().displayTimeAndRun(new Runnable(){

                @Override
                public void run() {
                    DevicesView.this.fOut.println("Collecting devices...");
                    int count = 0;
                    try {
                        count = DevicesView.this.getDevicesRecursive((Leaf)packsTree, devicesRoot, false);
                    }
                    catch (Exception e) {
                        Activator.log((Throwable)e);
                    }
                    if (devicesRoot.hasChildren()) {
                        DevicesView.this.fOut.println("Found " + count + " device(s), from " + devicesRoot.getChildren().size() + " vendor(s).");
                    } else {
                        DevicesView.this.fOut.println("Found none.");
                    }
                }
            });
        }
        if (!devicesRoot.hasChildren()) {
            Node empty = Node.addNewChild((Node)devicesRoot, (String)"none");
            empty.setName("(none)");
        }
        return devicesRoot;
    }

    private int getDevicesRecursive(Leaf node, Node root, boolean isInstalled) {
        int count;
        block5: {
            count = 0;
            String type = node.getType();
            if (!node.hasChildren()) break block5;
            if ("outline".equals(type) || "external".equals(type)) {
                for (Leaf child : ((Node)node).getChildren()) {
                    String childType = child.getType();
                    if (!"family".equals(childType)) continue;
                    count += this.addDevice(child, root, isInstalled);
                }
            } else {
                boolean isVersionInstalled = isInstalled;
                if ("version".equals(type) && node.isBooleanProperty("installed")) {
                    isVersionInstalled = true;
                }
                for (Leaf child : ((Node)node).getChildren()) {
                    count += this.getDevicesRecursive(child, root, isVersionInstalled);
                }
            }
        }
        return count;
    }

    private int addDevice(Leaf node, Node tree, boolean isInstalled) {
        int count = 0;
        String vendorName = node.getProperty("vendor.name");
        String vendorId = node.getProperty("vendor.id");
        Node vendorNode = Node.addUniqueChild((Node)tree, (String)"vendor", (String)vendorName);
        vendorNode.putProperty("vendor.id", vendorId);
        String deviceName = node.getName();
        String description = node.getDescription();
        Leaf deviceNode = vendorNode.findChild("family", deviceName);
        if (deviceNode == null) {
            deviceNode = Leaf.addNewChild((Node)vendorNode, (String)"family");
            deviceNode.setName(deviceName);
            deviceNode.setDescription(description);
            deviceNode.putProperty("vendor.name", vendorName);
            deviceNode.putProperty("vendor.id", vendorId);
            if (isInstalled) {
                deviceNode.setBooleanProperty("enabled", true);
            }
            ++count;
        }
        return count;
    }

    private void updateDevicesTree(Map<String, Leaf> updatedList) {
        Node modelTree = this.fDataManager.getRepositoriesTree();
        Node viewTree = (Node)this.fViewer.getInput();
        if (modelTree.hasChildren() && viewTree != null) {
            if (viewTree.hasChildren()) {
                for (Leaf vendor : viewTree.getChildren()) {
                    if (!vendor.hasChildren()) continue;
                    for (Leaf device : ((Node)vendor).getChildren()) {
                        device.setBooleanProperty("enabled", false);
                    }
                }
            }
            this.updateDevicesRecursive((Leaf)modelTree, viewTree, false, updatedList);
        }
    }

    private void updateDevicesRecursive(Leaf modelNode, Node viewTree, boolean isInstalled, Map<String, Leaf> updatedMap) {
        block5: {
            String type = modelNode.getType();
            if (!modelNode.hasChildren()) break block5;
            if ("outline".equals(type) || "external".equals(type)) {
                for (Leaf child : ((Node)modelNode).getChildren()) {
                    String childType = child.getType();
                    if (!"family".equals(childType)) continue;
                    this.updateDevice(child, viewTree, isInstalled, updatedMap);
                }
            } else {
                boolean isVersionInstalled = isInstalled;
                if ("version".equals(type) && modelNode.isBooleanProperty("installed")) {
                    isVersionInstalled = true;
                }
                for (Leaf child : ((Node)modelNode).getChildren()) {
                    this.updateDevicesRecursive(child, viewTree, isVersionInstalled, updatedMap);
                }
            }
        }
    }

    private void updateDevice(Leaf modelFamilyNode, Node viewTree, boolean isInstalled, Map<String, Leaf> updatedList) {
        Leaf deviceNode;
        String deviceName = modelFamilyNode.getName();
        String vendorName = modelFamilyNode.getProperty("vendor.name");
        String vendorId = modelFamilyNode.getProperty("vendor.id");
        Node vendorNode = (Node)viewTree.findChild("vendor", vendorName);
        if (vendorNode == null || !vendorId.equals(vendorNode.getProperty("vendor.id"))) {
            vendorNode = Node.addNewChild((Node)viewTree, (String)"vendor");
            vendorNode.setName(vendorName);
            vendorNode.putProperty("vendor.id", vendorId);
        }
        if ((deviceNode = vendorNode.findChild("family", deviceName)) == null) {
            deviceNode = Leaf.addNewChild((Node)vendorNode, (String)"family");
            deviceNode.setName(deviceName);
            String description = modelFamilyNode.getDescription();
            deviceNode.setDescription(description);
            deviceNode.putProperty("vendor.name", vendorName);
            deviceNode.putProperty("vendor.id", vendorId);
        }
        if (isInstalled) {
            deviceNode.setBooleanProperty("enabled", true);
            updatedList.put(vendorId, (Leaf)vendorNode);
        }
    }

    class NameComparator
    extends ViewerComparator {
        NameComparator() {
        }
    }

    class ViewContentProvider
    extends NodeViewContentProvider {
        ViewContentProvider() {
        }
    }

    class ViewLabelProvider
    extends CellLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return " " + ((Leaf)obj).getName();
        }

        public Image getImage(Object obj) {
            Leaf node = (Leaf)obj;
            String type = node.getType();
            if ("vendor".equals(type)) {
                String imageKey = "IMG_OBJ_FOLDER";
                return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
            }
            if ("family".equals(type)) {
                if (node.isBooleanProperty("enabled")) {
                    return Activator.getInstance().getImage("hardware_chip");
                }
                return Activator.getInstance().getImage("hardware_chip_grey");
            }
            return null;
        }

        public String getToolTipText(Object obj) {
            String description;
            Leaf node = (Leaf)obj;
            String type = node.getType();
            if ("vendor".equals(type)) {
                return "Vendor";
            }
            if ("family".equals(type) && (description = node.getDescription()) != null && description.length() > 0) {
                return description;
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }
    }
}

