/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.net.URI;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.text.asm.AsmPartitionScanner;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.text.ICPartitions;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;

public final class CDTUITools {
    private CDTUITools() {
    }

    public static IColorManager getColorManager() {
        return CUIPlugin.getDefault().getTextTools().getColorManager();
    }

    public static IEditorPart openInEditor(ICElement element) throws CModelException, PartInitException {
        return CDTUITools.openInEditor(element, true, true);
    }

    public static IEditorPart openInEditor(ICElement element, boolean activate, boolean reveal) throws CModelException, PartInitException {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (reveal && part != null) {
            EditorUtility.revealInEditor(part, element);
        }
        return part;
    }

    public static void revealInEditor(IEditorPart part, ICElement element) {
        EditorUtility.revealInEditor(part, element);
    }

    public static IWorkingCopyManager getWorkingCopyManager() {
        return CUIPlugin.getDefault().getWorkingCopyManager();
    }

    public static IDocumentProvider getDocumentProvider() {
        return CUIPlugin.getDefault().getDocumentProvider();
    }

    public static ICElement getEditorInputCElement(IEditorInput editorInput) {
        if (editorInput instanceof ITranslationUnitEditorInput) {
            return ((ITranslationUnitEditorInput)editorInput).getTranslationUnit();
        }
        IWorkingCopy tu = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (tu != null) {
            return tu;
        }
        return (ICElement)editorInput.getAdapter(ICElement.class);
    }

    public static IEditorInput getEditorInputForLocation(URI locationURI, ICElement context) {
        return EditorUtility.getEditorInputForLocation(locationURI, context);
    }

    public static IEditorInput getEditorInputForLocation(IPath location, ICElement context) {
        return EditorUtility.getEditorInputForLocation(location, context);
    }

    public static void setupCDocument(IDocument document, IPath location, LocationKind locationKind) {
        CUIPlugin.getDefault().getTextTools().setupCDocument(document, location, locationKind);
    }

    public static IDocumentPartitioner createAsmDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new AsmPartitionScanner(), ICPartitions.ALL_ASM_PARTITIONS);
    }

    public static void setupAsmDocument(IDocument document) {
        IDocumentPartitioner partitioner = CDTUITools.createAsmDocumentPartitioner();
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner("___c_partitioning", partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }
}

