/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractMarketplaceDiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DropDownButton;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.ItemButtonController;
import org.eclipse.epp.internal.mpc.ui.wizards.LinkListener;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.ShareSolutionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.StyledTextHelper;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class DiscoveryItem<T extends CatalogItem>
extends AbstractMarketplaceDiscoveryItem<T> {
    public static final String STYLING_CLASS = "DiscoveryItem";
    private static final String FAVORITED_BUTTON_STATE_DATA = "favorited";
    public static final String WIDGET_ID_INSTALLS = "installs";
    public static final String WIDGET_ID_TAGS = "tags";
    public static final String WIDGET_ID_RATING = "rating";
    public static final String WIDGET_ID_SHARE = "share";
    public static final String WIDGET_ID_LEARNMORE = "learn-more";
    public static final String WIDGET_ID_OVERVIEW = "overview";
    public static final String WIDGET_ID_ALREADY_INSTALLED = "already-installed";
    public static final String WIDGET_ID_ACTION = "action";
    public static final String WIDGET_ID_SCREENSHOT = "screenshot";
    private ItemButtonController buttonController;
    private StyledText installInfoLink;
    private ShareSolutionLink shareSolutionLink;
    private Button favoriteButton;
    private SelectionListener toggleFavoritesListener;

    public DiscoveryItem(Composite parent, int style, MarketplaceDiscoveryResources resources, IMarketplaceWebBrowser browser, T connector, MarketplaceViewer viewer) {
        super(parent, style, resources, browser, connector, viewer);
    }

    @Override
    protected String getItemClass() {
        return STYLING_CLASS;
    }

    @Override
    protected String getItemId() {
        return "item-" + this.connector.getId();
    }

    @Override
    protected void createInstallButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(0, 8).align(131072, 4).applyTo((Control)composite);
        int numColumns = 1;
        boolean installed = this.connector.isInstalled();
        final String url = this.getCatalogItemNode().getUrl();
        if (installed && this.getViewer().getContentType() != MarketplaceViewer.ContentType.INSTALLED && this.getViewer().getContentType() != MarketplaceViewer.ContentType.SELECTION) {
            Button alreadyInstalledButton = new Button(composite, 9);
            DiscoveryItem.setWidgetId((Widget)alreadyInstalledButton, WIDGET_ID_ALREADY_INSTALLED);
            new StyleHelper().on((Widget)alreadyInstalledButton).addClass("install-action");
            alreadyInstalledButton.setText(Messages.DiscoveryItem_AlreadyInstalled);
            alreadyInstalledButton.setFont(JFaceResources.getFontRegistry().getItalic(""));
            Point preferredSize = alreadyInstalledButton.computeSize(-1, -1);
            int preferredWidth = preferredSize.x + 10;
            GridDataFactory.swtDefaults().align(131072, 0x1000000).minSize(preferredWidth, -1).hint(preferredWidth, -1).grab(false, true).applyTo((Control)alreadyInstalledButton);
            alreadyInstalledButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DiscoveryItem.this.getViewer().setContentType(MarketplaceViewer.ContentType.INSTALLED);
                    DiscoveryItem.this.getViewer().reveal((Object)DiscoveryItem.this);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        } else if (this.hasInstallMetadata()) {
            DropDownButton dropDown = new DropDownButton(composite, 8);
            Button button = dropDown.getButton();
            DiscoveryItem.setWidgetId((Widget)button, WIDGET_ID_ACTION);
            new StyleHelper().on((Widget)button).addClass("install-action");
            Point preferredSize = button.computeSize(-1, -1);
            int preferredWidth = preferredSize.x + 10;
            GridDataFactory.swtDefaults().align(131072, 0x1000000).minSize(preferredWidth, -1).grab(false, true).applyTo((Control)button);
            this.buttonController = new ItemButtonController(this.getViewer(), this, dropDown);
        } else if (this.browser != null && url != null && !"".equals(url.trim())) {
            this.installInfoLink = StyledTextHelper.createStyledTextLabel(composite);
            DiscoveryItem.setWidgetId((Widget)this.installInfoLink, WIDGET_ID_LEARNMORE);
            this.installInfoLink.setToolTipText(Messages.DiscoveryItem_installInstructionsTooltip);
            StyledTextHelper.appendLink(this.installInfoLink, Messages.DiscoveryItem_installInstructions, Messages.DiscoveryItem_installInstructions, 1);
            new LinkListener(){

                @Override
                protected void selected(Object href, TypedEvent e) {
                    DiscoveryItem.this.browser.openUrl(url);
                }
            }.register(this.installInfoLink);
            GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(false, true).applyTo((Control)this.installInfoLink);
        } else {
            Label placeholder = new Label(composite, 0);
            placeholder.setText(" ");
            GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(false, true).applyTo((Control)placeholder);
        }
        GridLayoutFactory.fillDefaults().numColumns(numColumns).margins(0, 0).extendedMargins(0, 5, 0, 0).spacing(5, 0).applyTo(composite);
    }

    @Override
    protected void createInstallInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(8, 8).grab(true, false).align(1, 0x1000000).applyTo((Control)composite);
        RowLayoutFactory.fillDefaults().type(256).pack(true).applyTo(composite);
        Integer installsTotal = null;
        Integer installsRecent = null;
        if (this.connector.getData() instanceof INode) {
            INode node = (INode)this.connector.getData();
            installsTotal = node.getInstallsTotal();
            installsRecent = node.getInstallsRecent();
        }
        if (installsTotal != null || installsRecent != null) {
            StyledText installInfo = new StyledText(composite, 12);
            DiscoveryItem.setWidgetId((Widget)installInfo, WIDGET_ID_INSTALLS);
            String totalText = installsTotal == null ? Messages.DiscoveryItem_Unknown_Installs : MessageFormat.format(Messages.DiscoveryItem_Compact_Number, (int)installsTotal, (double)installsTotal.intValue() * 0.001, (double)installsTotal.intValue() * 1.0E-6);
            String recentText = installsRecent == null ? Messages.DiscoveryItem_Unknown_Installs : MessageFormat.format("{0, number}", (int)installsRecent);
            String installInfoText = NLS.bind((String)Messages.DiscoveryItem_Installs, (Object)totalText, (Object)recentText);
            int formatTotalsStart = installInfoText.indexOf(totalText);
            if (formatTotalsStart == -1) {
                installInfo.append(installInfoText);
            } else {
                if (formatTotalsStart > 0) {
                    installInfo.append(installInfoText.substring(0, formatTotalsStart));
                }
                StyledTextHelper.appendStyled(installInfo, totalText, new StyleRange(0, 0, null, null, 1));
                installInfo.append(installInfoText.substring(formatTotalsStart + totalText.length()));
            }
        } else if (this.shareSolutionLink != null) {
            this.shareSolutionLink.setShowText(true);
        }
    }

    @Override
    protected void createSocialButtons(Composite parent) {
        Integer favorited = this.getFavoriteCount();
        if (favorited == null || this.getCatalogItemUrl() == null) {
            this.createButtonBarSpacer(parent);
        } else {
            this.createFavoriteButton(parent);
        }
        if (this.getCatalogItemUrl() != null) {
            this.shareSolutionLink = new ShareSolutionLink(parent, this.connector);
            Control shareControl = this.shareSolutionLink.getControl();
            GridDataFactory.fillDefaults().indent(8, 8).align(1, 4).applyTo(shareControl);
        } else {
            this.createButtonBarSpacer(parent);
        }
    }

    private Integer getFavoriteCount() {
        if (this.connector.getData() instanceof INode) {
            INode node = (INode)this.connector.getData();
            return node.getFavorited();
        }
        return null;
    }

    private void createFavoriteButton(Composite parent) {
        this.favoriteButton = new Button(parent, 8);
        DiscoveryItem.setWidgetId((Widget)this.favoriteButton, WIDGET_ID_RATING);
        int width = -1;
        this.favoriteButton.setText("999");
        Point pSize = this.favoriteButton.computeSize(-1, -1, true);
        width = pSize.x;
        this.refreshFavoriteCount();
        pSize = this.favoriteButton.computeSize(-1, -1, true);
        width = Math.max(width, pSize.x);
        final String ratingDescription = NLS.bind((String)Messages.DiscoveryItem_Favorited_Times, (Object)this.favoriteButton.getText());
        this.favoriteButton.setToolTipText(ratingDescription);
        this.favoriteButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ratingDescription;
            }
        });
        GridDataFactory.fillDefaults().indent(0, 8).hint(Math.min(width, 75), -1).align(0x1000000, 4).applyTo((Control)this.favoriteButton);
    }

    private void refreshFavoriteCount() {
        Integer favoriteCount = this.getFavoriteCount();
        String favoriteCountText = favoriteCount == null ? "" : favoriteCount.toString();
        this.favoriteButton.setText(favoriteCountText);
    }

    private INode getCatalogItemNode() {
        Object data = this.connector.getData();
        if (data instanceof INode) {
            INode node = (INode)data;
            return node;
        }
        return null;
    }

    private String getCatalogItemUrl() {
        INode node = this.getCatalogItemNode();
        return node == null ? null : node.getUrl();
    }

    private boolean hasInstallMetadata() {
        if (!this.connector.getInstallableUnits().isEmpty() && this.connector.getSiteUrl() != null) {
            try {
                URLUtil.toURI((String)this.connector.getSiteUrl());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Deprecated
    protected boolean maybeModifySelection(Operation operation) {
        return this.maybeModifySelection(operation.getOperation());
    }

    protected boolean maybeModifySelection(org.eclipse.epp.mpc.ui.Operation operation) {
        this.getViewer().modifySelection(this.connector, operation);
        return true;
    }

    @Override
    public boolean isSelected() {
        return ((CatalogItem)this.getData()).isSelected();
    }

    @Deprecated
    public Operation getOperation() {
        return Operation.map(this.getSelectedOperation());
    }

    public org.eclipse.epp.mpc.ui.Operation getSelectedOperation() {
        return this.getViewer().getSelectionModel().getSelectedOperation((CatalogItem)this.getData());
    }

    @Override
    protected void refreshState() {
        if (this.buttonController != null) {
            this.buttonController.refresh();
        }
    }

    @Override
    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }

    @Override
    protected void searchForProvider(String searchTerm) {
        this.getViewer().search(searchTerm);
    }

    @Override
    protected void searchForTag(String tag) {
        this.getViewer().doQueryForTag(tag);
    }
}

