/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.opentype;

import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.browser.opentype.ElementSelectionDialog;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWorkbenchWindow;

    public void run(IAction action) {
        ElementSelectionDialog dialog = new ElementSelectionDialog(this.getShell());
        this.configureDialog(dialog);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        ITypeInfo info = (ITypeInfo)dialog.getFirstResult();
        if (info == null) {
            return;
        }
        ITypeReference location = info.getResolvedReference();
        if (location == null) {
            String title = OpenTypeMessages.OpenTypeAction_errorTitle;
            String message = NLS.bind((String)OpenTypeMessages.OpenTypeAction_errorTypeNotFound, (Object)info.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else if (!this.openTypeInEditor(location)) {
            String title = OpenTypeMessages.OpenTypeAction_errorTitle;
            String message = NLS.bind((String)OpenTypeMessages.OpenTypeAction_errorOpenEditor, (Object)location.getPath().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private void configureDialog(ElementSelectionDialog dialog) {
        String txt;
        ISelection sel;
        IWorkbenchPart part;
        IWorkbenchPage page;
        dialog.setTitle(OpenTypeMessages.OpenTypeDialog_title);
        dialog.setMessage(OpenTypeMessages.OpenTypeDialog_message);
        dialog.setDialogSettings(this.getClass().getName());
        if (this.fWorkbenchWindow != null && (page = this.fWorkbenchWindow.getActivePage()) != null && (part = page.getActivePart()) instanceof ITextEditor && (sel = ((ITextEditor)part).getSelectionProvider().getSelection()) instanceof ITextSelection && !(txt = ((ITextSelection)sel).getText()).isEmpty() && txt.length() < 80) {
            dialog.setFilter(txt, true);
        }
    }

    protected Shell getShell() {
        return this.fWorkbenchWindow.getShell();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openTypeInEditor(ITypeReference location) {
        ICElement[] cElements = location.getCElements();
        try {
            if (cElements != null && cElements.length > 0) {
                IEditorPart editor = EditorUtility.openInEditor(cElements[0]);
                EditorUtility.revealInEditor(editor, cElements[0]);
                return true;
            }
            ITranslationUnit unit = location.getTranslationUnit();
            IEditorPart editorPart = null;
            if (unit != null) {
                editorPart = EditorUtility.openInEditor(unit);
            }
            if (editorPart == null) {
                editorPart = EditorUtility.openInEditor(location.getLocation(), null);
            }
            if (editorPart == null || !(editorPart instanceof ITextEditor)) return false;
            ITextEditor editor = (ITextEditor)editorPart;
            if (!location.isLineNumber()) {
                editor.selectAndReveal(location.getOffset(), location.getLength());
                return true;
            }
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int startOffset = document.getLineOffset(location.getOffset() - 1);
                int length = document.getLineLength(location.getOffset() - 1);
                editor.selectAndReveal(startOffset, length);
                return true;
            }
            catch (BadLocationException ble) {
                return false;
            }
        }
        catch (CModelException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void dispose() {
        this.fWorkbenchWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

