/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidatorExtensionReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class ExtensionValidators {
    private static ExtensionValidators _me;
    private final Map<String, Validator> _map = new HashMap<String, Validator>(100);

    public static synchronized ExtensionValidators instance() {
        if (_me == null) {
            _me = new ExtensionValidators();
        }
        return _me;
    }

    private ExtensionValidators() {
        for (Validator v : ValidatorExtensionReader.getDefault().process()) {
            this._map.put(v.getId(), v);
        }
    }

    public Map<String, Validator> getMapV2() {
        return this._map;
    }

    public Map<String, Validator> getMapV2Copy() {
        HashMap<String, Validator> map = new HashMap<String, Validator>(this._map.size());
        map.putAll(this._map);
        return map;
    }

    public Map<String, Validator> getMap(IProject project) {
        HashMap<String, Validator> map = new HashMap<String, Validator>();
        map.putAll(this._map);
        for (Validator v : this.getV1Validators(project)) {
            map.put(v.getId(), v);
        }
        return map;
    }

    List<Validator> getV1Validators(IProject project) {
        LinkedList<Validator> list = new LinkedList<Validator>();
        try {
            ProjectConfiguration pc = new ProjectConfiguration(project);
            pc.resetToDefault();
            ValidatorMetaData[] validatorMetaDataArray = pc.getValidators();
            int n = validatorMetaDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidatorMetaData vmd = validatorMetaDataArray[n2];
                Validator v = Validator.create(vmd, pc, project);
                list.add(v);
                ++n2;
            }
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        return list;
    }
}

