/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.marker;

import com.google.common.base.Splitter;
import java.net.URL;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class GradleMarkerPropertyPage
extends PropertyPage {
    private Clipboard clipboard;

    public GradleMarkerPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).spacing(10, 6).applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        this.clipboard = new Clipboard(parent.getDisplay());
        this.initializeDialogUnits((Control)composite);
        this.doCreateContents(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doCreateContents(Composite parent) {
        IMarker marker = (IMarker)this.getElement().getAdapter(IMarker.class);
        Label idLabel = new Label(parent, 0);
        idLabel.setText("Problem:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)idLabel);
        Label idValue = new Label(parent, 0);
        idValue.setText(GradleMarkerPropertyPage.idDisplayName(marker.getAttribute("problem.id.displayname", (String)null), marker.getAttribute("problem.id.fqid", (String)null)));
        GridDataFactory.swtDefaults().span(2, 1).align(16384, 128).applyTo((Control)idValue);
        final String documentationLink = marker.getAttribute("problem.documentationlink", "");
        Label documentationLabel = new Label(parent, 0);
        documentationLabel.setText("Documentation:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)documentationLabel);
        Link documentationAreaText = new Link(parent, 8);
        GridDataFactory.fillDefaults().hint(100, 1).span(2, 1).grab(true, false).applyTo((Control)documentationAreaText);
        documentationAreaText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null).openURL(new URL(documentationLink));
                }
                catch (Exception e) {
                    CorePlugin.logger().warn("Cannot open URL + " + documentationLink, (Throwable)e);
                }
            }
        });
        documentationAreaText.setText("<a>" + documentationLink + "</a>");
        Label label = new Label(parent, 0);
        label.setText("Label:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)label);
        Label labelLvalue = new Label(parent, 0);
        labelLvalue.setText(marker.getAttribute("problem.label", ""));
        GridDataFactory.swtDefaults().span(2, 1).align(16384, 128).applyTo((Control)labelLvalue);
        Label details = new Label(parent, 0);
        details.setText("Details:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)details);
        Label detailsValue = new Label(parent, 0);
        detailsValue.setText(marker.getAttribute("problem.details", ""));
        GridDataFactory.swtDefaults().span(2, 1).align(16384, 128).applyTo((Control)detailsValue);
        String solutions = marker.getAttribute("problem.solutions", "");
        Label solutionsLabel = new Label(parent, 8);
        solutionsLabel.setText("Solutions:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)solutionsLabel);
        Text solutionsAreaText = new Text(parent, 10);
        GridDataFactory.fillDefaults().span(1, 1).hint(100, 50).grab(true, false).applyTo((Control)solutionsAreaText);
        solutionsAreaText.setText(solutions);
        new Label(parent, 0);
        String additionalData = marker.getAttribute("problem.additionaldata", "");
        Label additionalDataLabel = new Label(parent, 8);
        additionalDataLabel.setText("Additional data:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)additionalDataLabel);
        Text additionalDataText = new Text(parent, 10);
        GridDataFactory.fillDefaults().span(1, 1).hint(100, 50).grab(true, false).applyTo((Control)additionalDataText);
        additionalDataText.setText(additionalData);
        new Label(parent, 0);
        String stacktrace = marker.getAttribute("stacktrace", "(no stacktrace provided)");
        Label stackTraceLabel = new Label(parent, 0);
        stackTraceLabel.setText("Stacktrace:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)stackTraceLabel);
        final Text stacktraceAreaText = new Text(parent, 2570);
        GridDataFactory.fillDefaults().span(1, 1).hint(100, 100).grab(true, true).applyTo((Control)stacktraceAreaText);
        stacktraceAreaText.setText(stacktrace);
        Button copyButton = new Button(parent, 0x1000000);
        copyButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        copyButton.setToolTipText("Copy stacktrace");
        GridDataFactory.swtDefaults().align(16384, 1024).applyTo((Control)copyButton);
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] data = new Object[]{stacktraceAreaText.getText()};
                Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
                GradleMarkerPropertyPage.this.clipboard.setContents(data, dataTypes);
            }
        });
    }

    private static String idDisplayName(String displayName, String fqid) {
        StringBuilder result = new StringBuilder();
        if (displayName != null) {
            result.append(displayName);
        }
        if (fqid != null) {
            result.append(" (id: ");
            result.append(fqid);
            result.append(")");
        }
        return result.toString();
    }

    public static int countLines(String str) {
        return Splitter.on((String)System.lineSeparator()).splitToList((CharSequence)str).size();
    }
}

