/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.dispatch;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptCompilationParticipant;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.FileGenerationResult;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeAnnotationProcessorManager;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeMessagerImpl;
import org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.IElementInfo;

public abstract class IdeProcessingEnvImpl
extends BaseProcessingEnvImpl {
    private final IdeAnnotationProcessorManager _dispatchManager;
    private final IJavaProject _javaProject;
    protected final AptProject _aptProject;
    private final boolean _isTestCode;

    public IdeProcessingEnvImpl(IdeAnnotationProcessorManager dispatchManager, IJavaProject jproject, Compiler compiler, boolean isTestCode) {
        this._dispatchManager = dispatchManager;
        this._javaProject = jproject;
        this._compiler = compiler;
        this._isTestCode = isTestCode;
        this._aptProject = AptPlugin.getAptProject((IJavaProject)jproject);
        this._filer = new IdeFilerImpl(this._dispatchManager, this);
        this._messager = new IdeMessagerImpl(this._dispatchManager, this);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Map<String, String> getOptions() {
        if (this._processorOptions == null) {
            Map allOptions = AptConfig.getProcessorOptions((IJavaProject)this._javaProject, (boolean)this.isTestCode());
            Map<Boolean, List<Map.Entry>> isCommandLineOption = allOptions.entrySet().stream().collect(Collectors.partitioningBy(option -> ((String)option.getKey()).startsWith("-")));
            Map<String, String> commandLineOptions = isCommandLineOption.get(true).stream().collect(Collectors.toMap(e -> ((String)e.getKey()).substring(1), Map.Entry::getValue));
            Map<String, String> processorOptions = isCommandLineOption.get(false).stream().collect(Collectors.toMap(Map.Entry::getKey, this.replacePlaceholdersUsing(commandLineOptions)));
            processorOptions.put("phase", this.getPhase().toString());
            this._processorOptions = Collections.unmodifiableMap(processorOptions);
        }
        return this._processorOptions;
    }

    private Function<Map.Entry<String, String>, String> replacePlaceholdersUsing(Map<String, String> commandLineOptions) {
        return option -> {
            String replacement;
            String variable;
            String optionValue = option.getValue() == null ? "" : (String)option.getValue();
            Matcher placeholder = Pattern.compile("%([^%]+)%").matcher(optionValue);
            if (placeholder.find() && (variable = placeholder.group(1)) != null && (replacement = (String)commandLineOptions.get(variable)) != null) {
                optionValue = optionValue.replace("%" + variable + "%", replacement);
            }
            return optionValue;
        };
    }

    public AptProject getAptProject() {
        return this._aptProject;
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public IProject getProject() {
        return this._javaProject.getProject();
    }

    public abstract Phase getPhase();

    public IFile getEnclosingIFile(Element elem) {
        IElementInfo impl = (IElementInfo)elem;
        String name = impl.getFileName();
        if (name == null) {
            return null;
        }
        IFile file = this._javaProject.getProject().getParent().getFile((IPath)new Path(name));
        return file;
    }

    public void addNewUnit(FileGenerationResult result) {
        AptCompilationParticipant.getInstance().addJava6GeneratedFile(result.getFile());
        this.addNewUnit(this._dispatchManager.findCompilationUnit(result.getFile()));
    }

    public void addNewResource(IFile file) {
        AptCompilationParticipant.getInstance().addJava6GeneratedFile(file);
    }

    public boolean currentProcessorSupportsRTTG() {
        return false;
    }

    public boolean isTestCode() {
        return this._isTestCode;
    }

    public Compiler getCompiler() {
        return this._compiler;
    }
}

