/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.core;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.IContextListener;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;

public abstract class AbstractContextListener
implements IContextListener {
    @Deprecated
    public void contextPreActivated(IInteractionContext context) {
    }

    @Deprecated
    public void contextActivated(IInteractionContext context) {
    }

    @Deprecated
    public void contextDeactivated(IInteractionContext context) {
    }

    @Deprecated
    public void contextCleared(IInteractionContext context) {
    }

    @Deprecated
    public void interestChanged(List<IInteractionElement> elements) {
    }

    @Deprecated
    public void landmarkAdded(IInteractionElement element) {
    }

    @Deprecated
    public void landmarkRemoved(IInteractionElement element) {
    }

    @Deprecated
    public void elementsDeleted(List<IInteractionElement> elements) {
    }

    @Override
    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case PRE_ACTIVATED: {
                this.contextPreActivated(event.getContext());
                break;
            }
            case ACTIVATED: {
                this.contextActivated(event.getContext());
                break;
            }
            case DEACTIVATED: {
                this.contextDeactivated(event.getContext());
                break;
            }
            case CLEARED: {
                this.contextCleared(event.getContext());
                break;
            }
            case INTEREST_CHANGED: {
                this.interestChanged(event.getElements());
                break;
            }
            case LANDMARKS_ADDED: {
                for (IInteractionElement element : event.getElements()) {
                    this.landmarkAdded(element);
                }
                break;
            }
            case LANDMARKS_REMOVED: {
                for (IInteractionElement element : event.getElements()) {
                    this.landmarkRemoved(element);
                }
                break;
            }
            case ELEMENTS_DELETED: {
                this.elementsDeleted(event.getElements());
                break;
            }
            default: {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Unknown context changed event type"));
            }
        }
    }
}

