/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.contentmodel.internal.util;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocator;

public class XSDSchemaLocatorImpl
extends AdapterImpl
implements XSDSchemaLocator {
    public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
        XSDSchema result = null;
        String baseLocation = xsdSchema.getSchemaLocation();
        String resolvedURI = URIResolverPlugin.createResolver().resolve(baseLocation, namespaceURI, rawSchemaLocationURI);
        if (resolvedURI == null) {
            resolvedURI = resolvedSchemaLocationURI;
        }
        try {
            ResourceSet resourceSet = xsdSchema.eResource().getResourceSet();
            URI uri = URI.createURI((String)resolvedURI);
            Resource r = resourceSet.getResource(uri, false);
            XSDResourceImpl resolvedResource = null;
            if (r instanceof XSDResourceImpl) {
                resolvedResource = (XSDResourceImpl)r;
            } else {
                String physicalLocation = URIResolverPlugin.createResolver().resolvePhysicalLocation(baseLocation, namespaceURI, resolvedURI);
                InputStream inputStream = resourceSet.getURIConverter().createInputStream(URI.createURI((String)physicalLocation));
                resolvedResource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)"*.xsd"));
                resolvedResource.setURI(uri);
                resolvedResource.load(inputStream, null);
            }
            result = resolvedResource.getSchema();
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isAdatperForType(Object type) {
        return type == XSDSchemaLocator.class;
    }
}

