/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public abstract class CreateTypeMemberOperation
extends CreateElementInCUOperation {
    protected String source = null;
    protected String alteredName;
    protected ASTNode createdNode;

    public CreateTypeMemberOperation(IJavaScriptElement parentElement, String source, boolean force) {
        super(parentElement);
        this.source = source;
        this.force = force;
    }

    @Override
    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
        switch (parent.getNodeType()) {
            case 15: {
                if (this.createdNode instanceof AbstractTypeDeclaration) {
                    return JavaScriptUnit.TYPES_PROPERTY;
                }
                return JavaScriptUnit.STATEMENTS_PROPERTY;
            }
        }
        return TypeDeclaration.BODY_DECLARATIONS_PROPERTY;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, IJavaScriptUnit cu) throws JavaScriptModelException {
        if (this.createdNode == null) {
            String createdNodeSource;
            this.source = this.removeIndentAndNewLines(this.source, document, cu);
            ASTParser parser = ASTParser.newParser(3);
            parser.setSource(this.source.toCharArray());
            parser.setProject(this.getCompilationUnit().getJavaScriptProject());
            parser.setKind(4);
            ASTNode node = parser.createAST(this.progressMonitor);
            if (node.getNodeType() == 15) {
                JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
                this.createdNode = compilationUnit.statements().iterator().next();
                createdNodeSource = this.source;
            } else if (node.getNodeType() == 55) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                this.createdNode = (ASTNode)typeDeclaration.bodyDeclarations().iterator().next();
                createdNodeSource = this.source;
            } else {
                createdNodeSource = this.generateSyntaxIncorrectAST();
                if (this.createdNode == null) {
                    throw new JavaScriptModelException(new JavaModelStatus(984));
                }
            }
            if (this.alteredName != null) {
                SimpleName newName = this.createdNode.getAST().newSimpleName(this.alteredName);
                SimpleName oldName = this.rename(this.createdNode, newName);
                int nameStart = oldName.getStartPosition();
                int nameEnd = nameStart + oldName.getLength();
                StringBuffer newSource = new StringBuffer();
                if (this.source.equals(createdNodeSource)) {
                    newSource.append(createdNodeSource.substring(0, nameStart));
                    newSource.append(this.alteredName);
                    newSource.append(createdNodeSource.substring(nameEnd));
                } else {
                    int createdNodeStart = this.createdNode.getStartPosition();
                    int createdNodeEnd = createdNodeStart + this.createdNode.getLength();
                    newSource.append(createdNodeSource.substring(createdNodeStart, nameStart));
                    newSource.append(this.alteredName);
                    newSource.append(createdNodeSource.substring(nameEnd, createdNodeEnd));
                }
                this.source = newSource.toString();
            }
        }
        if (rewriter == null) {
            return this.createdNode;
        }
        return rewriter.createStringPlaceholder(this.source, this.createdNode.getNodeType());
    }

    private String removeIndentAndNewLines(String code, IDocument document, IJavaScriptUnit cu) {
        IJavaScriptProject project = cu.getJavaScriptProject();
        Map options = project.getOptions(true);
        int tabWidth = IndentManipulation.getTabWidth(options);
        int indentWidth = IndentManipulation.getIndentWidth(options);
        int indent = IndentManipulation.measureIndentUnits(code, tabWidth, indentWidth);
        int firstNonWhiteSpace = -1;
        int length = code.length();
        while (firstNonWhiteSpace < length - 1) {
            if (!ScannerHelper.isWhitespace(code.charAt(++firstNonWhiteSpace))) break;
        }
        int lastNonWhiteSpace = length;
        while (lastNonWhiteSpace > 0) {
            if (!ScannerHelper.isWhitespace(code.charAt(--lastNonWhiteSpace))) break;
        }
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        return IndentManipulation.changeIndent(code.substring(firstNonWhiteSpace, lastNonWhiteSpace + 1), indent, tabWidth, indentWidth, "", lineDelimiter);
    }

    protected abstract SimpleName rename(ASTNode var1, SimpleName var2);

    protected String generateSyntaxIncorrectAST() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.source);
        ASTParser parser = ASTParser.newParser(3);
        parser.setSource(buff.toString().toCharArray());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)parser.createAST(null);
        List<ASTNode> statements = compilationUnit.statements();
        if (statements.size() != 0) {
            this.createdNode = statements.iterator().next();
        }
        return buff.toString();
    }

    protected IType getType() {
        IJavaScriptElement parentElement = this.getParentElement();
        return parentElement instanceof IType ? (IType)parentElement : null;
    }

    @Override
    protected void setAlteredName(String newName) {
        this.alteredName = newName;
    }

    @Override
    public IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.source == null) {
            return new JavaModelStatus(984);
        }
        if (!this.force) {
            try {
                IJavaScriptUnit cu = this.getCompilationUnit();
                this.generateElementAST(null, this.getDocument(cu), cu);
            }
            catch (JavaScriptModelException jme) {
                return jme.getJavaScriptModelStatus();
            }
            return this.verifyNameCollision();
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected IJavaScriptModelStatus verifyNameCollision() {
        return JavaModelStatus.VERIFIED_OK;
    }
}

