/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dto.table;

import java.beans.Introspector;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IField;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.java.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.dto.AbstractDtoGenerator;
import org.eclipse.scout.sdk.core.s.java.annotation.ColumnDataAnnotation;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.util.ScoutTypeComparators;
import org.eclipse.scout.sdk.core.util.Ensure;

public class TableRowDataGenerator<TYPE extends TableRowDataGenerator<TYPE>>
extends AbstractDtoGenerator<TYPE> {
    protected static final int ROW_DATA_FIELD_FLAGS = 25;
    private final IType m_columnContainer;

    public TableRowDataGenerator(IType columnContainer, IType modelType, IJavaEnvironment targetEnv) {
        super(modelType, targetEnv);
        this.m_columnContainer = (IType)Ensure.notNull((Object)columnContainer);
    }

    @Override
    protected void copyAnnotations() {
    }

    protected Optional<String> getColumnValueType(IType columnContainer) {
        if (columnContainer == null) {
            return Optional.empty();
        }
        IScoutInterfaceApi.IColumn iColumn = this.scoutApi().IColumn();
        return columnContainer.resolveTypeParamValue(iColumn.valueTypeParamIndex(), iColumn.fqn()).flatMap(Stream::findFirst).map(IType::reference);
    }

    protected static String getColumnBeanName(IJavaElement column) {
        return Introspector.decapitalize(TableRowDataGenerator.removeFieldSuffix(column.elementName()));
    }

    protected Stream<IType> findColumnsToAdd(IType columnContainer, IType rowDataSuperType) {
        IScoutApi scoutApi = this.scoutApi();
        if (columnContainer.isInstanceOf((ITypeNameSupplier)scoutApi.IColumn())) {
            return Stream.of(columnContainer);
        }
        if (columnContainer.isInstanceOf((ITypeNameSupplier)scoutApi.IPageWithTableExtension())) {
            Optional tableExtension = ((HierarchyInnerTypeQuery)columnContainer.innerTypes().withSuperClasses(true).withInstanceOf((ITypeNameSupplier)scoutApi.ITableExtension())).first();
            columnContainer = tableExtension.orElse(columnContainer);
        }
        Stream<IType> allModelColumns = this.modelColumnsIn(columnContainer);
        if (rowDataSuperType == null) {
            return allModelColumns;
        }
        Set<String> usedColumnBeanNames = this.columnBeanNamesInRowData(rowDataSuperType);
        return allModelColumns.filter(column -> !usedColumnBeanNames.contains(TableRowDataGenerator.getColumnBeanName((IJavaElement)column)));
    }

    protected Set<String> columnBeanNamesInRowData(IType rowDataSuperType) {
        HashSet<String> usedColumnBeanNames = new HashSet<String>();
        Optional currentRowDataSuperType = Optional.of(rowDataSuperType);
        String abstractTableRowDataFqn = this.scoutApi().AbstractTableRowData().fqn();
        while (currentRowDataSuperType.isPresent() && !abstractTableRowDataFqn.equals(currentRowDataSuperType.orElseThrow().name())) {
            IType curSuperType = currentRowDataSuperType.orElseThrow();
            curSuperType.fields().withFlags(25).stream().map(IField::constantValue).flatMap(Optional::stream).filter(val -> val.type() == MetaValueType.String).map(val -> (String)val.as(String.class)).forEach(usedColumnBeanNames::add);
            currentRowDataSuperType = curSuperType.superClass();
        }
        return usedColumnBeanNames;
    }

    protected Stream<IType> modelColumnsIn(IType modelType) {
        return ((HierarchyInnerTypeQuery)modelType.innerTypes().withInstanceOf((ITypeNameSupplier)this.scoutApi().IColumn())).withSuperClasses(true).stream().filter(type -> ColumnDataAnnotation.sdkColumnCommandOf(type).orElse(ColumnDataAnnotation.SdkColumnCommand.CREATE) == ColumnDataAnnotation.SdkColumnCommand.CREATE).sorted(ScoutTypeComparators.orderAnnotationComparator(false));
    }

    @Override
    protected void setupBuilder() {
        super.setupBuilder();
        int flags = this.declaringGenerator().orElse(null) instanceof ITypeGenerator ? 9 : 1;
        if (Flags.isAbstract((int)this.columnContainer().flags()) || Flags.isAbstract((int)this.modelType().flags())) {
            flags |= 0x400;
        }
        this.withFlags(flags);
        Optional<String> superClass = this.superClassFunc().map(af -> (String)af.apply(this.currentBuilder().context()));
        if (superClass.isEmpty()) {
            this.withInterface(Serializable.class.getName());
        }
        Optional rowDataSuperClassType = superClass.map(JavaTypes::erasure).flatMap(arg_0 -> ((IJavaEnvironment)this.targetEnvironment()).findType(arg_0));
        this.findColumnsToAdd(this.columnContainer(), rowDataSuperClassType.orElse(null)).forEach(this::withDtoTypeForColumn);
    }

    protected TYPE withDtoTypeForColumn(IType column) {
        String columnBeanName = TableRowDataGenerator.getColumnBeanName((IJavaElement)column);
        String columnValueType = this.getColumnValueType(column).orElseGet(() -> {
            SdkLog.warning((CharSequence)"Column '{}' has no value type.", (Object[])new Object[]{column.name()});
            return Object.class.getName();
        });
        IFieldGenerator memberFieldGenerator = ((IFieldGenerator)((IFieldGenerator)FieldGenerator.create().asPrivate()).withElementName("m_" + columnBeanName)).withDataType(columnValueType);
        return (TYPE)((Object)((TableRowDataGenerator)((TableRowDataGenerator)((TableRowDataGenerator)((TableRowDataGenerator)this.withField(((IFieldGenerator)((IFieldGenerator)FieldGenerator.create().withElementName(columnBeanName)).withFlags(25)).withDataType(String.class.getName()).withValue(b -> b.stringLiteral((CharSequence)columnBeanName)), new Object[0])).withField(memberFieldGenerator, new Object[0])).withMethod(MethodGenerator.createGetter((IFieldGenerator)memberFieldGenerator), new Object[0])).withMethod(MethodGenerator.createSetter((String)((String)memberFieldGenerator.elementName().orElseThrow()), (String)columnValueType, (int)1, (String)"new"), new Object[0])));
    }

    @Override
    protected String computeSuperType() {
        IScoutApi scoutApi = this.scoutApi();
        if (this.m_columnContainer.isInstanceOf((ITypeNameSupplier)scoutApi.IExtension()) || !(this.declaringGenerator().orElse(null) instanceof ITypeGenerator)) {
            return null;
        }
        String superTypeOfSurroundingTableBeanGenerator = this.declaringGenerator().map(jeg -> (ITypeGenerator)jeg).flatMap(ITypeGenerator::superClassFunc).map(af -> (String)af.apply(this.currentBuilder().context())).orElseThrow();
        if (superTypeOfSurroundingTableBeanGenerator.equals(scoutApi.AbstractTablePageData().fqn()) || superTypeOfSurroundingTableBeanGenerator.equals(scoutApi.AbstractTableFieldBeanData().fqn())) {
            return this.defaultSuperClass();
        }
        return this.targetEnvironment().findType(superTypeOfSurroundingTableBeanGenerator).flatMap(s -> ((HierarchyInnerTypeQuery)s.innerTypes().withInstanceOf((ITypeNameSupplier)scoutApi.AbstractTableRowData())).first()).map(IType::reference).orElseGet(this::defaultSuperClass);
    }

    protected String defaultSuperClass() {
        return this.scoutApi().AbstractTableRowData().fqn();
    }

    public IType columnContainer() {
        return this.m_columnContainer;
    }

    @Override
    public IType modelType() {
        return super.modelType();
    }
}

