/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class UnusedCodeCleanUp
extends AbstractCleanUp {
    public UnusedCodeCleanUp(Map options) {
        super(options);
    }

    public UnusedCodeCleanUp() {
    }

    @Override
    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        boolean removeUnuseMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_methods") || removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_local_variables");
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean removeUnuseMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFix.createCleanUp(compilationUnit, removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_methods"), removeUnuseMembers && this.isEnabled("cleanup.remove_private_constructors"), removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_fields"), removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false);
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean removeMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFix.createCleanUp(compilationUnit, problems, removeMembers && this.isEnabled("cleanup.remove_unused_private_methods"), removeMembers && this.isEnabled("cleanup.remove_private_constructors"), removeMembers && this.isEnabled("cleanup.remove_unused_private_fields"), removeMembers && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false);
    }

    @Override
    public Map getRequiredOptions() {
        boolean removeMembers;
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport", "warning");
        }
        if ((removeMembers = this.isEnabled("cleanup.remove_unused_private_members")) && (this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_private_types"))) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "warning");
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "warning");
        }
        return options;
    }

    @Override
    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedMethod_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedField_description);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedVariable_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_fields")) {
            buf.append("    var fField;\n");
        }
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_methods")) {
            buf.append("    function foo() {}\n");
        }
        buf.append("    function bar() {\n");
        if (!this.isEnabled("cleanup.remove_unused_local_variables")) {
            buf.append("        var i= 10;\n");
        }
        buf.append("    }\n");
        return buf.toString();
    }

    @Override
    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        UnusedCodeFix fix;
        if (this.isEnabled("cleanup.remove_unused_imports") && (fix = UnusedCodeFix.createRemoveUnusedImportFix(compilationUnit, problem)) != null) {
            return true;
        }
        return (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_local_variables")) && (fix = UnusedCodeFix.createUnusedMemberFix(compilationUnit, problem, false)) != null;
    }

    @Override
    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            int i = 0;
            while (i < problems.length) {
                int id = problems[i].getID();
                if (id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            result += this.getNumberOfProblems(problems, 603979894);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors")) {
            result += this.getNumberOfProblems(problems, 603979910);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types")) {
            result += this.getNumberOfProblems(problems, 553648135);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            result += this.getNumberOfProblems(problems, 570425421);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result += this.getNumberOfProblems(problems, 536870973);
        }
        return result;
    }
}

