/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AbstractRulerToggleBreakpointActionDelegate;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointToggleUtils;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RulerToggleHitBreakpointActionDelegate
extends AbstractRulerToggleBreakpointActionDelegate {
    @Override
    protected boolean doWork(ITextEditor editor, ITextSelection selection) {
        IJavaLineBreakpoint jlp;
        block4: {
            jlp = ToggleBreakpointAdapter.findExistingBreakpoint(this.currentEditor, selection);
            try {
                this.hitCountDialog();
                if (BreakpointToggleUtils.getHitCount() >= 1) break block4;
                return false;
            }
            catch (CoreException e) {
                DebugUIPlugin.log((Throwable)e);
                return false;
            }
        }
        if (jlp != null) {
            ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)jlp, (IWorkbenchPart)editor, null);
        }
        BreakpointToggleUtils.setHitpoint(true);
        return true;
    }

    private void hitCountDialog() {
        String title = ActionMessages.BreakpointHitCountAction_Set_Breakpoint_Hit_Count_2;
        String message = ActionMessages.BreakpointHitCountAction__Enter_the_new_hit_count_for_the_breakpoint__3;
        IInputValidator validator = new IInputValidator(){
            int hitCount = -1;

            public String isValid(String value) {
                try {
                    this.hitCount = Integer.parseInt(value.trim());
                }
                catch (NumberFormatException nfe) {
                    this.hitCount = -1;
                }
                if (this.hitCount < 1) {
                    return ActionMessages.BreakpointHitCountAction_Value_must_be_positive_integer;
                }
                return null;
            }
        };
        Shell activeShell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        InputDialog input = new InputDialog(activeShell, title, message, "", validator);
        if (input.open() == 1) {
            return;
        }
        String hit = input.getValue();
        if (hit != null && !hit.isEmpty()) {
            BreakpointToggleUtils.setHitCount(Integer.parseInt(hit));
        }
    }
}

