/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui;

import java.text.DecimalFormat;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.swt.widgets.Event;
import org.jacoco.core.analysis.ICounter;

public final class RedGreenBar {
    private static final int BORDER_LEFT = 2;
    private static final int BORDER_RIGHT = 10;
    private static final int BORDER_TOP = 3;
    private static final int BORDER_BOTTOM = 4;
    private static final String MAX_PERCENTAGE_STRING = new DecimalFormat(UIMessages.CoverageView_columnCoverageValue).format(1.0);

    private RedGreenBar() {
    }

    public static void draw(Event event, int columnWith, ICounter counter) {
        RedGreenBar.draw(event, columnWith, counter, counter.getTotalCount());
    }

    public static void draw(Event event, int columnWith, ICounter counter, int maxTotal) {
        if (maxTotal == 0) {
            return;
        }
        int maxWidth = RedGreenBar.getMaxWidth(event, columnWith);
        int redLength = maxWidth * counter.getMissedCount() / maxTotal;
        RedGreenBar.bar(event, "icons/full/dgm/redbar.png", 0, redLength);
        int greenLength = maxWidth * counter.getCoveredCount() / maxTotal;
        RedGreenBar.bar(event, "icons/full/dgm/greenbar.png", redLength, greenLength);
    }

    private static void bar(Event event, String image, int xOffset, int width) {
        int height = event.getBounds().height - 3 - 4;
        event.gc.drawImage(EclEmmaUIPlugin.getImage(image), 0, 0, 1, 10, event.x + xOffset + 2, event.y + 3, width, height);
    }

    private static int getMaxWidth(Event event, int columnWith) {
        int textWidth = event.gc.textExtent((String)RedGreenBar.MAX_PERCENTAGE_STRING).x;
        int max = columnWith - 2 - 10 - textWidth;
        return Math.max(0, max);
    }
}

