/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.publisher.AbstractPublisherTask;
import org.eclipse.pde.internal.build.publisher.BuildPublisherApplication;
import org.eclipse.pde.internal.build.publisher.FeatureRootAdvice;
import org.eclipse.pde.internal.build.publisher.GatherFeatureAction;
import org.eclipse.pde.internal.build.publisher.GatheringComputer;
import org.eclipse.pde.internal.build.tasks.TaskMessages;

public class GatherFeatureTask
extends AbstractPublisherTask {
    private String buildResultFolder = null;
    private String targetFolder = null;
    private String licenseDirectory = null;

    public void execute() throws BuildException {
        GatheringComputer computer = this.createFeatureComputer();
        GatherFeatureAction action = null;
        action = this.targetFolder == null ? new GatherFeatureAction(new File(this.baseDirectory), new File(this.buildResultFolder)) : new GatherFeatureAction(new File(this.baseDirectory), new File(this.targetFolder));
        action.setComputer(computer);
        this.setGroupId(action);
        FeatureRootAdvice advice = this.createRootAdvice();
        action.setRootAdvice(advice);
        PublisherInfo info = this.getPublisherInfo();
        info.addAdvice((IPublisherAdvice)advice);
        BuildPublisherApplication application = this.createPublisherApplication();
        application.addAction((IPublisherAction)action);
        try {
            application.run(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setGroupId(GatherFeatureAction action) {
        Properties properties = this.getBuildProperties();
        if (properties.containsKey("p2.group.id")) {
            action.setGroupId(properties.getProperty("p2.group.id"));
        }
    }

    protected GatheringComputer createFeatureComputer() {
        Properties properties = this.getBuildProperties();
        String include = (String)properties.get("bin.includes");
        String exclude = (String)properties.get("bin.excludes");
        if (include == null) {
            return null;
        }
        if (this.targetFolder != null) {
            FileSet fileSet = new FileSet();
            fileSet.setProject(this.getProject());
            fileSet.setDir(new File(this.targetFolder));
            PatternSet.NameEntry includeEntry = fileSet.createInclude();
            includeEntry.setName("**");
            String[] files = fileSet.getDirectoryScanner().getIncludedFiles();
            if (files != null && files.length > 0) {
                GatheringComputer computer = new GatheringComputer();
                computer.addFiles(this.targetFolder, files);
                return computer;
            }
            return null;
        }
        GatheringComputer computer = new GatheringComputer();
        if (this.licenseDirectory != null) {
            try {
                String licenseInclude = "**";
                Object licenseExclude = "META-INF/";
                if (new File(this.licenseDirectory, "build.properties").exists()) {
                    Properties licenseProperties = AbstractScriptGenerator.readProperties((String)this.licenseDirectory, (String)"build.properties", (int)2);
                    licenseInclude = (String)licenseProperties.get("bin.includes");
                    licenseExclude = (String)licenseProperties.get("bin.excludes");
                }
                licenseExclude = (String)(licenseExclude != null ? (String)licenseExclude + "," : "") + ",.project,build.properties,feature.xml,feature.properties,feature_*.properties";
                FileSet licenseFiles = this.createFileSet(this.licenseDirectory, licenseInclude, (String)licenseExclude);
                computer.addFiles(this.licenseDirectory, licenseFiles.getDirectoryScanner().getIncludedFiles());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        FileSet fileSet = this.createFileSet(this.buildResultFolder, include, exclude);
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner();
        computer.addFiles(this.buildResultFolder, directoryScanner.getIncludedFiles());
        computer.addFiles(this.buildResultFolder, directoryScanner.getIncludedDirectories());
        return computer;
    }

    private FileSet createFileSet(String folder, String includes, String excludes) {
        String[] splitExcludes;
        String[] splitIncludes;
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(new File(folder));
        String[] stringArray = splitIncludes = Utils.getArrayFromString((String)includes);
        int n = splitIncludes.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (!entry.equals(".")) {
                PatternSet.NameEntry fileInclude = fileSet.createInclude();
                fileInclude.setName(entry);
            }
            ++n2;
        }
        String[] stringArray2 = splitExcludes = Utils.getArrayFromString((String)excludes);
        int n3 = splitExcludes.length;
        n = 0;
        while (n < n3) {
            String splitExclude = stringArray2[n];
            PatternSet.NameEntry fileExclude = fileSet.createExclude();
            fileExclude.setName(splitExclude);
            ++n;
        }
        return fileSet;
    }

    private String reorderConfig(String config) {
        String[] parsed = Utils.getArrayFromString((String)config, (String)".");
        return parsed[1] + "." + parsed[0] + "." + parsed[2];
    }

    protected FeatureRootAdvice createRootAdvice() {
        FeatureRootAdvice advice = new FeatureRootAdvice();
        Map configMap = Utils.processRootProperties((Properties)this.getBuildProperties(), (boolean)true);
        for (String config : configMap.keySet()) {
            Object file;
            int n;
            Map rootMap = (Map)configMap.get(config);
            config = config.equals("!!COMMON!!") ? "" : this.reorderConfig(config);
            GatheringComputer computer = new GatheringComputer();
            HashMap<FileSet, String> configFileSets = new HashMap<FileSet, String>();
            ArrayList<String> permissionsKeys = new ArrayList<String>();
            for (String key : rootMap.keySet()) {
                String[] files;
                if (key.startsWith("!!ROOT.PERMISSIONS!!")) {
                    permissionsKeys.add(key);
                    continue;
                }
                if (key.equals("!!ROOT.LINK!!")) {
                    advice.addLinks(config, (String)rootMap.get(key));
                    continue;
                }
                String fileList = (String)rootMap.get(key);
                String[] stringArray = files = Utils.getArrayFromString((String)fileList, (String)",");
                n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file2 = stringArray[n2];
                    file = file2;
                    String fromDir = this.baseDirectory;
                    File base = null;
                    if (((String)file).startsWith("absolute:")) {
                        file = ((String)file).substring(9);
                        fromDir = null;
                    } else if (((String)file).startsWith("license:")) {
                        if (this.licenseDirectory == null) {
                            throw new BuildException(NLS.bind((String)TaskMessages.error_licenseRootWithoutLicenseRef, (Object)this.baseDirectory));
                        }
                        file = ((String)file).substring(8);
                        fromDir = this.licenseDirectory;
                    }
                    if (((String)file).startsWith("file:")) {
                        File temp = fromDir != null ? new File(fromDir, ((String)file).substring(5)) : new File(((String)file).substring(5));
                        base = temp.getParentFile();
                        file = temp.getName();
                    } else {
                        base = fromDir != null ? new File(fromDir, (String)file) : new File((String)file);
                        file = "**";
                    }
                    if (base.exists()) {
                        String[] found;
                        FileSet fileset = new FileSet();
                        fileset.setProject(this.getProject());
                        fileset.setDir(base);
                        PatternSet.NameEntry include = fileset.createInclude();
                        include.setName((String)file);
                        String[] stringArray2 = found = fileset.getDirectoryScanner().getIncludedFiles();
                        int n3 = found.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String element = stringArray2[n4];
                            if (key.length() > 0) {
                                computer.addFile(key + "/" + element, new File(base, element));
                            } else {
                                computer.addFile(base.getAbsolutePath(), element);
                            }
                            ++n4;
                        }
                        configFileSets.put(fileset, key);
                    }
                    ++n2;
                }
            }
            if (computer.size() > 0) {
                advice.addRootfiles(config, computer);
            }
            for (String permissionKey : permissionsKeys) {
                String permissionString = (String)rootMap.get(permissionKey);
                String[] names = Utils.getArrayFromString((String)permissionString);
                OrSelector orSelector = new OrSelector();
                orSelector.setProject(this.getProject());
                file = names;
                int n5 = names.length;
                n = 0;
                while (n < n5) {
                    String name = file[n];
                    FilenameSelector nameSelector = new FilenameSelector();
                    nameSelector.setProject(this.getProject());
                    nameSelector.setName(name);
                    orSelector.addFilename(nameSelector);
                    ++n;
                }
                for (FileSet fileset : configFileSets.keySet()) {
                    String finalFolder = (String)configFileSets.get(fileset);
                    String[] found = this.selectFiles(orSelector, finalFolder, fileset.getDirectoryScanner().getIncludedFiles());
                    if (found.length <= 0) continue;
                    advice.addPermissions(config, permissionKey.substring("!!ROOT.PERMISSIONS!!".length()), found);
                }
            }
        }
        return advice;
    }

    private String[] selectFiles(OrSelector selector, String folder, String[] files) {
        Object prefix = folder.length() > 0 ? folder + "/" : "";
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Object finalLocation = (String)prefix + file;
            if (selector.isSelected(null, (String)(finalLocation = ((String)finalLocation).replace('/', File.separatorChar).replace('\\', File.separatorChar)), null)) {
                result.add(((String)finalLocation).replace('\\', '/'));
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public void setBuildResultFolder(String buildResultFolder) {
        if (buildResultFolder != null && buildResultFolder.length() > 0 && !buildResultFolder.startsWith("${")) {
            this.buildResultFolder = buildResultFolder;
        }
    }

    public void setTargetFolder(String targetFolder) {
        if (targetFolder != null && targetFolder.length() > 0 && !targetFolder.startsWith("${")) {
            this.targetFolder = targetFolder;
        }
    }

    public void setLicenseDirectory(String licenseDirectory) {
        if (licenseDirectory != null && licenseDirectory.length() > 0 && !licenseDirectory.startsWith("${")) {
            this.licenseDirectory = licenseDirectory;
        }
    }
}

