/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.internal.ui.coverageview.CoverageView;
import org.eclipse.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;

class CoverageViewSorter
extends ViewerComparator {
    private final ViewSettings settings;
    private final CoverageView view;
    private final ViewerComparator elementsorter = new JavaElementComparator();

    public CoverageViewSorter(ViewSettings settings, CoverageView view) {
        this.settings = settings;
        this.view = view;
    }

    void addColumn(TreeViewerColumn viewerColumn, final int columnidx) {
        final TreeColumn column = viewerColumn.getColumn();
        if (this.settings.getSortColumn() == columnidx) {
            this.setSortColumnAndDirection(column, this.settings.isReverseSort());
        }
        column.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CoverageViewSorter.this.settings.toggleSortColumn(columnidx);
                CoverageViewSorter.this.setSortColumnAndDirection(column, CoverageViewSorter.this.settings.isReverseSort());
                CoverageViewSorter.this.view.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setSortColumnAndDirection(TreeColumn sortColumn, boolean reverse) {
        sortColumn.getParent().setSortColumn(sortColumn);
        sortColumn.getParent().setSortDirection(reverse ? 1024 : 128);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ICoverageNode.CounterEntity counters = this.settings.getCounters();
        ICounter c1 = CoverageTools.getCoverageInfo((Object)e1).getCounter(counters);
        ICounter c2 = CoverageTools.getCoverageInfo((Object)e2).getCounter(counters);
        int res = 0;
        switch (this.settings.getSortColumn()) {
            case 0: {
                res = this.elementsorter.compare(viewer, e1, e2);
                break;
            }
            case 1: {
                res = Double.compare(c1.getCoveredRatio(), c2.getCoveredRatio());
                break;
            }
            case 2: {
                res = c1.getCoveredCount() - c2.getCoveredCount();
                break;
            }
            case 3: {
                res = c1.getMissedCount() - c2.getMissedCount();
                break;
            }
            case 4: {
                res = c1.getTotalCount() - c2.getTotalCount();
            }
        }
        res = res == 0 ? this.elementsorter.compare(viewer, e1, e2) : (this.settings.isReverseSort() ? -res : res);
        return res;
    }
}

